/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.config.IllageAndSpillageConfig;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CrocofangEntity
extends Raider
implements ICanBeAnimated {
    private static final UUID SPEED_PENALTY_UUID = UUID.fromString("5BD14A52-AB9A-42D3-A649-90FDE044281E");
    private static final AttributeModifier SPEED_PENALTY;
    private static final EntityDataAccessor<Integer> ANIMATION_STATE;
    private static final EntityDataAccessor<Boolean> TRIED_SPAWN;
    private static final EntityDataAccessor<Boolean> CHARGING;
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState prechargeAnimationState = new AnimationState();
    public AnimationState chargeAnimationState = new AnimationState();
    public AnimationState stunnedAnimationState = new AnimationState();
    private int biteTime;
    private int chargeTime;
    private int stunnedTime;
    double chargeX;
    double chargeZ;

    public CrocofangEntity(EntityType<? extends Raider> p_37839_, Level p_37840_) {
        super(p_37839_, p_37840_);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new StunGoal());
        this.f_21345_.m_25352_(0, (Goal)new ChargeGoal());
        this.f_21345_.m_25352_(0, (Goal)new AttackGoal());
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true, p_199899_ -> !p_199899_.m_6162_()));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected void m_8022_() {
        boolean flag = !(this.m_6688_() instanceof Mob) || this.m_6688_().m_6095_().m_204039_(EntityTypeTags.f_13121_);
        boolean flag1 = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, flag);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, flag && flag1);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
        this.f_21345_.m_25360_(Goal.Flag.TARGET, flag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 3.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(TRIED_SPAWN, (Object)false);
        this.f_19804_.m_135372_(CHARGING, (Object)false);
    }

    public void m_7380_(CompoundTag p_37870_) {
        super.m_7380_(p_37870_);
        if (this.hasAlreadyTriedSpawn()) {
            p_37870_.m_128379_("HasAlreadyTriedSpawn", true);
        }
    }

    public void m_7378_(CompoundTag p_37862_) {
        super.m_7378_(p_37862_);
        this.setTriedSpawn(p_37862_.m_128471_("HasAlreadyTriedSpawn"));
    }

    public double m_6048_() {
        if (this.stunnedTime > 0) {
            return 1.15;
        }
        return super.m_6048_() * 1.15;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean hasAlreadyTriedSpawn() {
        return (Boolean)this.f_19804_.m_135370_(TRIED_SPAWN);
    }

    public void setTriedSpawn(boolean triedSpawn) {
        this.f_19804_.m_135381_(TRIED_SPAWN, (Object)triedSpawn);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    public SoundEvent m_7930_() {
        return null;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_CROCOFANG_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_CROCOFANG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_CROCOFANG_DEATH.get();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.hasAlreadyTriedSpawn()) {
            if (this.m_20197_().isEmpty()) {
                this.spawnMob();
            }
            this.setTriedSpawn(true);
        }
        if (this.chargeTime > 0 || this.stunnedTime > 0) {
            AttributeInstance $$4 = this.m_21051_(Attributes.f_22279_);
            assert ($$4 != null);
            $$4.m_22130_(SPEED_PENALTY);
            $$4.m_22118_(SPEED_PENALTY);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22130_(SPEED_PENALTY);
        }
        if (this.m_6084_()) {
            if (this.biteTime > 0) {
                --this.biteTime;
                if (this.biteTime == 11) {
                    float f1 = (float)this.m_21133_(Attributes.f_22282_);
                    float radius2 = 2.0f;
                    double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                    double y = this.m_20186_() + 1.0 + (double)radius2 * Math.sin((double)(-this.m_146909_()) * Math.PI / 180.0);
                    double z = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                    List list = this.f_19853_.m_45976_(LivingEntity.class, new AABB(x - 1.0, this.m_20186_(), z - 1.0, x + 1.0, this.m_20186_() + 1.0, z + 1.0));
                    for (LivingEntity caught : list) {
                        if (caught == this || !caught.m_6084_() || !EntityUtil.canHurtThisMob((Entity)caught, (Mob)this)) continue;
                        caught.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22115_());
                        caught.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                    }
                }
            }
            if (this.chargeTime > 0) {
                ++this.chargeTime;
                this.m_146922_(this.m_6080_());
                this.f_20883_ = this.m_146908_();
                if (this.m_5448_() != null) {
                    LivingEntity t = this.m_5448_();
                    double chargex = this.m_20185_() - t.m_20185_();
                    double chargey = this.m_20186_() - t.m_20186_();
                    double chargez = this.m_20189_() - t.m_20189_();
                    double charged = Math.sqrt(chargex * chargex + chargey * chargey + chargez * chargez);
                    float power = 3.8f;
                    double motionX = this.m_20184_().f_82479_ - chargex / charged * (double)power * 0.2;
                    double motionZ = this.m_20184_().f_82481_ - chargez / charged * (double)power * 0.2;
                    if (this.chargeTime == 30) {
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_CROCOFANG_CHARGE.get(), 3.0f, 1.0f);
                        this.setAnimationState(3);
                        if (!this.f_19853_.f_46443_) {
                            this.setCharging(true);
                        }
                        this.setCharge(motionX, motionZ);
                    }
                    if (this.chargeTime > 30 && this.chargeTime <= 64) {
                        this.m_20334_(this.chargeX, this.m_20184_().f_82480_, this.chargeZ);
                        for (Entity entity : this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                            if (!EntityUtil.canHurtThisMob(entity, (Mob)this) || !(entity instanceof LivingEntity) || !entity.m_6084_()) continue;
                            double x = this.m_20185_() - entity.m_20185_();
                            double y = this.m_20186_() - entity.m_20186_();
                            double z = this.m_20189_() - entity.m_20189_();
                            double d = Math.sqrt(x * x + y * y + z * z);
                            if (!(this.m_20280_(entity) < 9.0)) continue;
                            if (entity.f_19802_ <= 0) {
                                this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                                entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 8.0f);
                                entity.f_19864_ = true;
                                entity.m_20334_(-x / d * 2.0, -y / d * 2.0 + 0.5, -z / d * 2.0);
                            }
                            if (!((LivingEntity)entity).m_21254_()) continue;
                            EntityUtil.disableShield((LivingEntity)entity, 100);
                            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.7f);
                            this.m_6469_(DamageSource.m_19370_((LivingEntity)((LivingEntity)entity)), 4.0f);
                            this.setAnimationState(4);
                            if (!this.f_19853_.f_46443_) {
                                this.setCharging(false);
                            }
                            this.chargeTime = 0;
                            this.stunnedTime = 120;
                        }
                        if (this.f_19862_) {
                            this.m_5496_(SoundEvents.f_12314_, 1.0f, 0.7f);
                            this.m_6469_(DamageSource.f_19318_, 4.0f);
                            this.setAnimationState(4);
                            if (!this.f_19853_.f_46443_) {
                                this.setCharging(false);
                            }
                            this.chargeTime = 0;
                            this.stunnedTime = 120;
                        }
                    }
                }
                if (this.chargeTime >= 70) {
                    this.chargeAnimationState.m_216973_();
                    this.setAnimationState(0);
                    if (!this.f_19853_.f_46443_) {
                        this.setCharging(false);
                    }
                    this.chargeTime = 0;
                }
            }
        }
        if (this.stunnedTime > 0) {
            --this.stunnedTime;
        }
    }

    public void setCharge(double x, double z) {
        this.chargeX = x;
        this.chargeZ = z;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
    }

    private void spawnMob() {
        BlockPos blockPos = this.m_20097_();
        boolean summonedMobFromConfig = this.summonMobFromConfig(blockPos);
    }

    private boolean summonMobFromConfig(BlockPos blockPos) {
        List mobSpawns = (List)IllageAndSpillageConfig.crocofang_rideableMobs.get();
        if (mobSpawns.isEmpty()) {
            return false;
        }
        Collections.shuffle(mobSpawns);
        int randomIndex = this.m_217043_().m_188503_(mobSpawns.size());
        String randomMobID = (String)mobSpawns.get(randomIndex);
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(randomMobID));
        if (entityType == null) {
            return false;
        }
        Entity entity = entityType.m_20615_(this.f_19853_);
        if (!(entity instanceof Mob)) {
            return false;
        }
        if (entity instanceof CrocofangEntity) {
            return false;
        }
        Mob mobEntity = (Mob)entity;
        DifficultyInstance difficultyForLocation = this.f_19853_.m_6436_(blockPos.m_7494_());
        mobEntity.m_20035_(blockPos.m_7494_(), this.m_146908_(), 0.0f);
        mobEntity.m_7998_((Entity)this, false);
        if (!this.f_19853_.f_46443_) {
            mobEntity.m_6518_((ServerLevelAccessor)this.f_19853_, difficultyForLocation, MobSpawnType.EVENT, (SpawnGroupData)null, (CompoundTag)null);
        }
        if (mobEntity instanceof Raider) {
            ((Raider)mobEntity).m_37897_(true);
        }
        return this.f_19853_.m_7967_((Entity)mobEntity);
    }

    public boolean m_7327_(Entity p_21372_) {
        if (this.biteTime < 1 && this.chargeTime < 1 && this.stunnedTime < 1) {
            this.attackAnimationState.m_216973_();
            this.setAnimationState(0);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_CROCOFANG_BITE.get(), 1.0f, 1.0f);
            this.biteTime = 20;
            this.setAnimationState(1);
        }
        return false;
    }

    public void setAnimationState(int input) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)input);
    }

    @Override
    public AnimationState getAnimationState(String input) {
        if (input == "attack") {
            return this.attackAnimationState;
        }
        if (input == "precharge") {
            return this.prechargeAnimationState;
        }
        if (input == "charge") {
            return this.chargeAnimationState;
        }
        if (input == "stunned") {
            return this.stunnedAnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.chargeAnimationState.m_216973_();
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.attackAnimationState.m_216973_();
                    this.prechargeAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.prechargeAnimationState.m_216973_();
                    this.chargeAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.chargeAnimationState.m_216973_();
                    this.stunnedAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (this.m_20197_().contains(p_37849_.m_7639_())) {
            return false;
        }
        return super.m_6469_(p_37849_, p_37850_);
    }

    static {
        ANIMATION_STATE = SynchedEntityData.m_135353_(CrocofangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        TRIED_SPAWN = SynchedEntityData.m_135353_(CrocofangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        CHARGING = SynchedEntityData.m_135353_(CrocofangEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        SPEED_PENALTY = new AttributeModifier(SPEED_PENALTY_UUID, "STOP MOVING AROUND STUPID", -0.35, AttributeModifier.Operation.ADDITION);
    }

    class StunGoal
    extends Goal {
        public boolean m_8036_() {
            return CrocofangEntity.this.stunnedTime > 0;
        }

        public boolean m_8045_() {
            return CrocofangEntity.this.stunnedTime > 0;
        }

        public StunGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public void m_8037_() {
            CrocofangEntity.this.m_21573_().m_26573_();
            CrocofangEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            CrocofangEntity.this.stunnedAnimationState.m_216973_();
            CrocofangEntity.this.setAnimationState(0);
        }
    }

    class ChargeGoal
    extends Goal {
        public boolean m_8036_() {
            return CrocofangEntity.this.biteTime < 1 && CrocofangEntity.this.m_5448_() != null && CrocofangEntity.this.m_142582_((Entity)CrocofangEntity.this.m_5448_()) && CrocofangEntity.this.f_19796_.m_188501_() * 75.0f < 0.9f && CrocofangEntity.this.m_20280_((Entity)CrocofangEntity.this.m_5448_()) > 27.0 && CrocofangEntity.this.stunnedTime < 1;
        }

        public boolean m_8045_() {
            return CrocofangEntity.this.chargeTime > 0;
        }

        public void m_8056_() {
            CrocofangEntity.this.attackAnimationState.m_216973_();
            CrocofangEntity.this.setAnimationState(2);
            CrocofangEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_CROCOFANG_PREPARE_CHARGE.get(), 3.0f, 1.0f);
            CrocofangEntity.this.chargeTime = 1;
        }

        public ChargeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public void m_8037_() {
            CrocofangEntity.this.m_21573_().m_26573_();
            if (CrocofangEntity.this.m_5448_() != null) {
                CrocofangEntity.this.m_21563_().m_24960_((Entity)CrocofangEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            CrocofangEntity.this.f_21344_.m_26573_();
        }
    }

    class AttackGoal
    extends Goal {
        public boolean m_8036_() {
            return CrocofangEntity.this.biteTime > 0;
        }

        public boolean m_8045_() {
            return CrocofangEntity.this.biteTime > 0;
        }

        public AttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public void m_8037_() {
            CrocofangEntity.this.m_21573_().m_26573_();
            if (CrocofangEntity.this.m_5448_() != null) {
                CrocofangEntity.this.m_21563_().m_24960_((Entity)CrocofangEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            CrocofangEntity.this.f_21344_.m_26573_();
        }
    }
}

