/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.config.IllageAndSpillageConfig;
import com.yellowbrossproductions.illageandspillage.entities.CrashagerEntity;
import com.yellowbrossproductions.illageandspillage.entities.DispenserEntity;
import com.yellowbrossproductions.illageandspillage.entities.FakeMagispellerEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerBoss;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class OldMagispellerEntity
extends AbstractIllager
implements IllagerBoss {
    private final List<FakeMagispellerEntity> clones = new ArrayList<FakeMagispellerEntity>();
    private static final EntityDataAccessor<Boolean> FAKING = SynchedEntityData.m_135353_(OldMagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NEARBY_ILLAGERS = SynchedEntityData.m_135353_(OldMagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_DELETE_ITSELF = SynchedEntityData.m_135353_(OldMagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WAVING_ARMS = SynchedEntityData.m_135353_(OldMagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPINNING = SynchedEntityData.m_135353_(OldMagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> VINDICATOR_ATTACKING = SynchedEntityData.m_135353_(OldMagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CROSSBOW_ATTACKING = SynchedEntityData.m_135353_(OldMagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FORCEFIELD = SynchedEntityData.m_135353_(OldMagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WEEEEEEEEEEEE = SynchedEntityData.m_135353_(OldMagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(OldMagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int attackTicks;
    private int attackType;
    private int CLONES_ATTACK = 1;
    private int CROSSBOWSPIN_ATTACK = 2;
    private int HEAL_ATTACK = 3;
    private int DISPENSER_ATTACK = 4;
    private int FANGRUN_ATTACK = 5;
    private int SUMMON_ATTACK = 6;
    private int POTIONS_ATTACK = 7;
    private int FIREBALL_ATTACK = 8;
    private int LIFESTEAL_ATTACK = 9;
    private int RAVAGER_ATTACK = 10;
    private int spinDirection;
    private int dispenserCooldown;
    private int vexCooldown;
    private int pullPower;
    private int waitTimeFaker;

    public OldMagispellerEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 100;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new RavagerGoal());
        this.f_21345_.m_25352_(0, (Goal)new LifeStealGoal());
        this.f_21345_.m_25352_(0, (Goal)new ShootFireballGoal());
        this.f_21345_.m_25352_(0, (Goal)new ThrowPotionsGoal());
        this.f_21345_.m_25352_(0, (Goal)new SummonVexesGoal());
        this.f_21345_.m_25352_(0, (Goal)new FangRunGoal());
        this.f_21345_.m_25352_(0, (Goal)new DispenserGoal());
        this.f_21345_.m_25352_(0, (Goal)new HealGoal());
        this.f_21345_.m_25352_(0, (Goal)new CrossbowSpinGoal());
        this.f_21345_.m_25352_(0, (Goal)new ClonesGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new StareAtTargetGoal());
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity entity = this.m_5448_();
        if (this.isFaking() && this.f_19796_.m_188503_(10) == 0 && entity != null && this.m_20280_((Entity)entity) > 1024.0) {
            this.teleportTowards((Entity)entity);
        }
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        if (this.isFaking()) {
            return false;
        }
        return super.m_142535_(p_225503_1_, p_225503_2_, p_147189_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FAKING, (Object)false);
        this.f_19804_.m_135372_(NEARBY_ILLAGERS, (Object)false);
        this.f_19804_.m_135372_(SHOULD_DELETE_ITSELF, (Object)false);
        this.f_19804_.m_135372_(WAVING_ARMS, (Object)false);
        this.f_19804_.m_135372_(SPINNING, (Object)false);
        this.f_19804_.m_135372_(VINDICATOR_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(CROSSBOW_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(FORCEFIELD, (Object)false);
        this.f_19804_.m_135372_(WEEEEEEEEEEEE, (Object)false);
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
    }

    public boolean m_6779_(LivingEntity p_213336_1_) {
        if (this.areIllagersNearby()) {
            return false;
        }
        return super.m_6779_(p_213336_1_);
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        super.m_7380_(p_213281_1_);
        if (this.isFaking()) {
            p_213281_1_.m_128379_("IsFaking", true);
        }
        if (this.isActive()) {
            p_213281_1_.m_128379_("active", true);
        }
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        super.m_7378_(p_70037_1_);
        this.setFaking(p_70037_1_.m_128471_("IsFaking"));
        this.setActive(p_70037_1_.m_128471_("active"));
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    protected float m_6431_(Pose p_213348_1_, EntityDimensions p_213348_2_) {
        return 1.66f;
    }

    public void m_8119_() {
        double d;
        double z;
        double y;
        List list = this.f_19853_.m_6443_(Raider.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.m_37886_() && !(predicate instanceof IllagerBoss));
        if (((Boolean)IllageAndSpillageConfig.magispeller_forcefield.get()).booleanValue() && this.m_37886_()) {
            if (!this.f_19853_.f_46443_) {
                this.setIllagersNearby(!list.isEmpty());
            }
            if (!list.isEmpty()) {
                this.m_6710_(null);
            }
        }
        if (this.m_37886_()) {
            if (this.m_37885_() != null && this.m_37885_().m_37771_() == 7 && this.shouldRemoveItself() && ((Boolean)IllageAndSpillageConfig.magispeller_onlyOneAllowed.get()).booleanValue()) {
                this.m_37885_().m_37740_((Raider)this, true);
                if (!this.f_19853_.f_46443_) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
            if (this.m_37885_() != null) {
                this.m_37885_().m_37776_();
            }
        }
        this.attackTicks = this.attackType > 0 ? ++this.attackTicks : 0;
        --this.dispenserCooldown;
        if (this.dispenserCooldown < 0) {
            this.dispenserCooldown = 0;
        }
        --this.vexCooldown;
        if (this.vexCooldown < 0) {
            this.vexCooldown = 0;
        }
        this.pullPower = this.attackType == this.LIFESTEAL_ATTACK && this.attackTicks > 36 ? ++this.pullPower : 0;
        if (this.m_5448_() == null && !this.clones.isEmpty()) {
            for (FakeMagispellerEntity clone : this.clones) {
                clone.m_6074_();
            }
        }
        if (this.isFaking() && this.clones.isEmpty() && !this.f_19853_.f_46443_) {
            this.setFaking(false);
            this.setVindicatorAttacking(false);
        }
        this.updateCloneList();
        if (this.isSpinning()) {
            ++this.spinDirection;
            if (this.spinDirection > 4) {
                this.spinDirection = 1;
            }
            this.f_20883_ = this.spinDirection * 90;
        }
        if (this.isWavingArms() && this.f_19853_.f_46443_) {
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, 0.1, 0.1, 0.2);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, 0.1, 0.1, 0.2);
        }
        if (this.areIllagersNearby()) {
            this.stopAttackersFromAttacking();
        }
        this.waitTimeFaker = this.isFaking() ? ++this.waitTimeFaker : 0;
        if (this.isForcefieldProtected()) {
            for (Entity entity : this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                if (!EntityUtil.canHurtThisMob(entity, (Mob)this) || !entity.m_6084_()) continue;
                double x = this.m_20185_() - entity.m_20185_();
                y = this.m_20186_() - entity.m_20186_();
                z = this.m_20189_() - entity.m_20189_();
                d = Math.sqrt(x * x + y * y + z * z);
                if (!(this.m_20280_(entity) < 9.0)) continue;
                entity.f_19864_ = true;
                entity.m_20334_(-x / d * 2.0, -y / d * 2.0, -z / d * 2.0);
                entity.m_6001_(-x / d * 2.0, -y / d * 2.0, -z / d * 2.0);
            }
        }
        if (this.isGoingWEEEEEEEEEEE() && !this.m_20159_()) {
            this.setWEEEEEEEEEEEEE(false);
        }
        if (this.m_6084_()) {
            if (this.attackType == this.CLONES_ATTACK) {
                this.m_21573_().m_26573_();
                if (this.attackTicks == 18) {
                    this.setWavingArms(false);
                    this.setSpinning(true);
                }
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
                this.f_21344_.m_26573_();
            }
            if (this.attackType == this.CROSSBOWSPIN_ATTACK) {
                this.m_21573_().m_26573_();
                if (this.attackTicks == 8) {
                    this.m_5496_(SoundEvents.f_11846_, 1.0f, 1.0f);
                }
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
                if (this.attackTicks == 18) {
                    this.setSpinning(false);
                    this.setCrossbowAttacking(true);
                    if (this.m_5448_() != null) {
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_ARROWBARRAGE.get(), 2.0f, 1.0f);
                    }
                }
                if (this.attackTicks >= 18 && this.m_5448_() != null) {
                    this.fireArrow(this.m_5448_(), 1.0f, 0.5f);
                }
                this.f_21344_.m_26573_();
            }
            if (this.attackType == this.HEAL_ATTACK) {
                this.m_21573_().m_26573_();
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
                this.f_21344_.m_26573_();
            }
            if (this.attackType == this.DISPENSER_ATTACK) {
                this.m_21573_().m_26573_();
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
                this.f_21344_.m_26573_();
            }
            if (this.attackType == this.FANGRUN_ATTACK) {
                this.m_21573_().m_26573_();
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
                if (this.attackTicks >= 43) {
                    if (this.attackTicks == 43) {
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_FORCEFIELD.get(), 1.0f, 1.0f);
                        if (!this.f_19853_.f_46443_) {
                            this.setForcefield(true);
                        }
                        if (this.f_19853_.f_46443_) {
                            for (int i = 0; i < 25; ++i) {
                                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                            }
                        }
                    }
                    this.createFangs();
                    this.m_5496_(SoundEvents.f_11865_, 1.0f, this.m_6100_());
                }
                this.f_21344_.m_26573_();
            }
            if (this.attackType == this.SUMMON_ATTACK) {
                this.m_21573_().m_26573_();
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
                this.f_21344_.m_26573_();
            }
            if (this.attackType == this.POTIONS_ATTACK) {
                this.m_21573_().m_26573_();
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
                if (this.attackTicks == 18 || this.attackTicks == 36) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_SPIN.get(), 1.0f, 1.0f);
                }
                if (this.attackTicks > 17 && !this.f_19853_.f_46443_) {
                    ThrownPotion potionentity = new ThrownPotion(this.f_19853_, (LivingEntity)this);
                    potionentity.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43617_));
                    potionentity.m_146926_(-20.0f);
                    potionentity.m_6686_(-2.0 + (this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_()), 2.0 + this.f_19796_.m_188500_() + this.f_19796_.m_188500_(), -2.0 + (this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_()), 0.75f, 8.0f);
                    this.f_19853_.m_7967_((Entity)potionentity);
                }
                this.f_21344_.m_26573_();
            }
            if (this.attackType == this.FIREBALL_ATTACK) {
                LivingEntity livingentity;
                this.m_21573_().m_26573_();
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
                if (this.attackTicks == 44 && !this.f_19853_.f_46443_ && (livingentity = this.m_5448_()) != null) {
                    double d1 = 4.0;
                    Vec3 vector3d = this.m_20252_(1.0f);
                    double d2 = livingentity.m_20185_() - (this.m_20185_() + vector3d.f_82479_ * 4.0);
                    double d3 = livingentity.m_20227_(0.5) - (0.5 + this.m_20227_(0.5));
                    double d4 = livingentity.m_20189_() - (this.m_20189_() + vector3d.f_82481_ * 4.0);
                    LargeFireball fireballentity = new LargeFireball(this.f_19853_, (LivingEntity)this, d2, d3, d4, 3);
                    fireballentity.m_6034_(this.m_20185_() + vector3d.f_82479_, this.m_20186_() + 1.5, this.m_20189_() + vector3d.f_82481_);
                    fireballentity.m_5602_((Entity)this);
                    this.f_19853_.m_7967_((Entity)fireballentity);
                }
                this.f_21344_.m_26573_();
            }
            if (this.attackType == this.LIFESTEAL_ATTACK) {
                this.m_21573_().m_26573_();
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
                if (this.attackTicks == 18) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_SPIN.get(), 1.0f, 1.0f);
                }
                if (this.attackTicks == 36) {
                    this.setSpinning(false);
                    this.setWavingArms(true);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_LIFESTEAL.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks >= 36) {
                    for (Entity entity : this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(entity, (Mob)this) || !entity.m_6084_() || !this.isMobNotInCreativeMode(entity)) continue;
                        double x = this.m_20185_() - entity.m_20185_();
                        y = this.m_20186_() - entity.m_20186_();
                        z = this.m_20189_() - entity.m_20189_();
                        d = Math.sqrt(x * x + y * y + z * z);
                        float power = (float)this.pullPower / 103.0f;
                        double motionX = entity.m_20184_().f_82479_ + x / d * (double)power * 0.2;
                        double motionY = entity.m_20184_().f_82480_ + y / d * (double)power * 0.2;
                        double motionZ = entity.m_20184_().f_82481_ + z / d * (double)power * 0.2;
                        entity.f_19864_ = true;
                        entity.m_20334_(motionX, motionY, motionZ);
                        entity.m_6001_(motionX, motionY, motionZ);
                        if (this.f_19853_.f_46443_) {
                            for (int i = 0; i < 2; ++i) {
                                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, entity.m_20208_(0.5), entity.m_20187_(), entity.m_20262_(0.5), 0.0, 0.0, 0.0);
                            }
                        }
                        if (!(this.m_20280_(entity) < 9.0) || !(entity instanceof LivingEntity)) continue;
                        if (((LivingEntity)entity).f_20916_ <= 0) {
                            double healthStolen = 0.0;
                            healthStolen = (((LivingEntity)entity).m_21233_() - ((LivingEntity)entity).m_21223_()) / 3.0f + 1.0f;
                            if (healthStolen > 10.0) {
                                healthStolen = 10.0;
                            }
                            this.m_5634_((float)healthStolen);
                            entity.m_6469_(DamageSource.m_19367_((Entity)this, (Entity)this), (float)healthStolen);
                        }
                        entity.f_19864_ = true;
                        entity.m_20334_(-x / d * 2.0, -y / d * 2.0, -z / d * 2.0);
                        entity.m_6001_(-x / d * 2.0, -y / d * 2.0, -z / d * 2.0);
                    }
                }
                this.f_21344_.m_26573_();
            }
            if (this.attackType == this.RAVAGER_ATTACK) {
                this.m_21573_().m_26573_();
                this.m_20334_(0.0, 0.06, 0.0);
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
                this.f_21344_.m_26573_();
            }
        }
        super.m_8119_();
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if ((this.areIllagersNearby() || this.isForcefieldProtected()) && p_70097_1_ != DamageSource.f_19317_) {
            return false;
        }
        if (this.isFaking()) {
            this.setFaking(false);
            this.setVindicatorAttacking(false);
            if (!this.clones.isEmpty()) {
                for (FakeMagispellerEntity clone : this.clones) {
                    clone.m_6074_();
                }
            }
        }
        if (p_70097_1_ != DamageSource.f_19317_ && p_70097_2_ > 20.0f) {
            p_70097_2_ = 20.0f;
        }
        if (p_70097_1_.m_7640_() instanceof LargeFireball) {
            p_70097_2_ = 5.0f;
        }
        if (p_70097_1_.m_7639_() instanceof CrashagerEntity && ((CrashagerEntity)p_70097_1_.m_7639_()).getOwner() == this) {
            return false;
        }
        if (p_70097_1_.m_7639_() instanceof LivingEntity && !this.isActive() && !this.areIllagersNearby()) {
            this.setActive(true);
            if (this.m_37886_() && this.m_37885_() != null) {
                this.m_37885_().f_37673_ = 0L;
            }
        }
        return super.m_6469_(p_70097_1_, p_70097_2_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        RandomSource randomsource = p_213386_1_.m_213780_();
        if (p_213386_3_ == MobSpawnType.EVENT) {
            this.setShouldDeleteItself(true);
        }
        this.m_213945_(randomsource, p_213386_2_);
        this.m_213946_(randomsource, p_213386_2_);
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public void m_6667_(DamageSource p_37847_) {
        if (this.m_37886_() && this.m_37885_() != null) {
            this.m_37885_().f_37673_ = 0L;
        }
        super.m_6667_(p_37847_);
    }

    public boolean m_7327_(Entity p_70652_1_) {
        if (this.isFaking() && !this.f_19853_.f_46443_ && this.f_19796_.m_188503_(3) != 0) {
            this.teleportTowards(p_70652_1_);
        }
        if (this.isFaking() && this.waitTimeFaker < 20) {
            return false;
        }
        return super.m_7327_(p_70652_1_);
    }

    protected void createFangs() {
        if (this.m_5448_() != null) {
            LivingEntity livingentity = this.m_5448_();
            double d0 = Math.min(livingentity.m_20186_(), this.m_20186_());
            double d1 = Math.max(livingentity.m_20186_(), this.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.m_20189_()), (double)(livingentity.m_20185_() - this.m_20185_()));
            for (int l = 0; l < 16; ++l) {
                double d2 = 1.25 * (double)(l + 1);
                int j = 1 * l;
                this.createSpellEntity(this.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, j);
            }
        }
    }

    private void createSpellEntity(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
        BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)this.f_19853_, blockpos1, Direction.UP)) continue;
            if (!this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_190876_5_) - 1);
        if (flag) {
            EvokerFangs fangs = new EvokerFangs(this.f_19853_, p_190876_1_, (double)blockpos.m_123342_() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (LivingEntity)this);
            fangs.m_20225_(true);
            this.f_19853_.m_7967_((Entity)fangs);
        }
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_CELEBRATE.get();
    }

    protected SoundEvent m_7515_() {
        return !this.isFaking() ? (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_AMBIENT.get() : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FAKER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_DEATH.get();
    }

    public Component m_7755_() {
        return !this.m_8077_() && this.isFaking() ? ((EntityType)ModEntityTypes.Faker.get()).m_20676_() : super.m_7755_();
    }

    public boolean isFaking() {
        return (Boolean)this.f_19804_.m_135370_(FAKING);
    }

    public void setFaking(boolean faking) {
        this.f_19804_.m_135381_(FAKING, (Object)faking);
    }

    public boolean areIllagersNearby() {
        return (Boolean)this.f_19804_.m_135370_(NEARBY_ILLAGERS);
    }

    public void setIllagersNearby(boolean illagersNearby) {
        this.f_19804_.m_135381_(NEARBY_ILLAGERS, (Object)illagersNearby);
    }

    public boolean shouldRemoveItself() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_DELETE_ITSELF);
    }

    public void setShouldDeleteItself(boolean shouldDelete) {
        this.f_19804_.m_135381_(SHOULD_DELETE_ITSELF, (Object)shouldDelete);
    }

    public boolean isWavingArms() {
        return (Boolean)this.f_19804_.m_135370_(WAVING_ARMS);
    }

    public void setWavingArms(boolean waving) {
        this.f_19804_.m_135381_(WAVING_ARMS, (Object)waving);
    }

    public boolean isSpinning() {
        return (Boolean)this.f_19804_.m_135370_(SPINNING);
    }

    public void setSpinning(boolean spinning) {
        this.f_19804_.m_135381_(SPINNING, (Object)spinning);
    }

    public boolean isVindicatorAttacking() {
        return (Boolean)this.f_19804_.m_135370_(VINDICATOR_ATTACKING);
    }

    public void setVindicatorAttacking(boolean attacking) {
        this.f_19804_.m_135381_(VINDICATOR_ATTACKING, (Object)attacking);
    }

    public boolean isCrossbowAttacking() {
        return (Boolean)this.f_19804_.m_135370_(CROSSBOW_ATTACKING);
    }

    public void setCrossbowAttacking(boolean attacking) {
        this.f_19804_.m_135381_(CROSSBOW_ATTACKING, (Object)attacking);
    }

    public boolean isForcefieldProtected() {
        return (Boolean)this.f_19804_.m_135370_(FORCEFIELD);
    }

    public void setForcefield(boolean forcefield) {
        this.f_19804_.m_135381_(FORCEFIELD, (Object)forcefield);
    }

    public boolean isGoingWEEEEEEEEEEE() {
        return (Boolean)this.f_19804_.m_135370_(WEEEEEEEEEEEE);
    }

    public void setWEEEEEEEEEEEEE(boolean weeeeeeee) {
        this.f_19804_.m_135381_(WEEEEEEEEEEEE, (Object)weeeeeeee);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(ACTIVE, (Object)active);
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean m_7301_(MobEffectInstance p_70687_1_) {
        return p_70687_1_.m_19544_() != MobEffects.f_19597_ && super.m_7301_(p_70687_1_);
    }

    public void stopAttackersFromAttacking() {
        List list = this.f_19853_.m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
        for (Mob attacker : list) {
            if (attacker.m_21188_() == this) {
                attacker.m_6703_(null);
            }
            if (attacker.m_5448_() != this) continue;
            attacker.m_6710_(null);
        }
    }

    protected void m_213945_(RandomSource random, DifficultyInstance p_180481_1_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42717_));
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    public boolean doesAttackMeetNormalRequirements() {
        return this.attackType == 0 && !this.isFaking() && !this.areIllagersNearby() && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.isActive();
    }

    public boolean isTargetLowEnoughForGround() {
        return this.m_5448_() != null && !(this.m_5448_().m_20186_() > this.m_20186_() + 3.0);
    }

    public boolean isTargetCloseEnoughForRange() {
        return this.m_5448_() != null && this.m_20280_((Entity)this.m_5448_()) < 26.0;
    }

    protected boolean teleport() {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            double d0 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            double d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
            double d2 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
            return this.teleport(d0, d1, d2);
        }
        return false;
    }

    private boolean teleportTowards(Entity p_70816_1_) {
        Vec3 vector3d = new Vec3(this.m_20185_() - p_70816_1_.m_20185_(), this.m_20227_(0.5) - p_70816_1_.m_20188_(), this.m_20189_() - p_70816_1_.m_20189_());
        vector3d = vector3d.m_82541_();
        double d0 = 16.0;
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vector3d.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.m_123342_() > 0 && !this.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_60767_().m_76334_()) {
            blockpos$mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutable);
        boolean flag = blockstate.m_60767_().m_76334_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_70825_1_, (double)p_70825_3_, (double)p_70825_5_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    public void updateCloneList() {
        if (!this.clones.isEmpty()) {
            for (int i = 0; i < this.clones.size(); ++i) {
                FakeMagispellerEntity clone = this.clones.get(i);
                if (clone.m_6084_()) continue;
                this.clones.remove(i);
                --i;
            }
        }
    }

    public void distractAttackers(LivingEntity entity) {
        List list = this.f_19853_.m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
        for (Mob attacker : list) {
            if (attacker.m_21188_() == this) {
                attacker.m_6703_(entity);
            }
            if (attacker.m_5448_() != this) continue;
            attacker.m_6710_(entity);
        }
    }

    public void fireArrow(LivingEntity p_82196_1_, float p_82196_2_, float inaccuracy) {
        AbstractArrow abstractarrowentity = this.getArrow(Items.f_42411_.m_7968_(), p_82196_2_);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
        }
        double d0 = p_82196_1_.m_20185_() - this.m_20185_();
        double d1 = p_82196_1_.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_() - 0.1;
        double d2 = p_82196_1_.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        abstractarrowentity.m_36781_(2.5);
        float speed = this.m_20280_((Entity)p_82196_1_) > 22.5 ? 2.5f : (float)(this.m_20280_((Entity)p_82196_1_) / 9.0);
        abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, speed, inaccuracy);
        this.f_19853_.m_7967_((Entity)abstractarrowentity);
    }

    protected AbstractArrow getArrow(ItemStack p_213624_1_, float p_213624_2_) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)p_213624_1_, (float)p_213624_2_);
    }

    public boolean isMobNotInCreativeMode(Entity entity) {
        if (entity instanceof Player) {
            return !((Player)entity).m_7500_() && !((Player)entity).m_5833_();
        }
        return true;
    }

    class RavagerGoal
    extends Goal {
        public RavagerGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldMagispellerEntity.this.doesAttackMeetNormalRequirements() && OldMagispellerEntity.this.f_19796_.m_188501_() * 75.0f < 0.9f && OldMagispellerEntity.this.isTargetLowEnoughForGround() && !OldMagispellerEntity.this.m_20159_();
        }

        public void m_8056_() {
            OldMagispellerEntity.this.setSpinning(true);
            OldMagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_RAVAGER.get(), 2.0f, 1.0f);
            OldMagispellerEntity.this.attackType = OldMagispellerEntity.this.RAVAGER_ATTACK;
        }

        public boolean m_8045_() {
            return OldMagispellerEntity.this.attackTicks <= 68;
        }

        public void m_8037_() {
        }

        public void m_8041_() {
            OldMagispellerEntity.this.attackTicks = 0;
            OldMagispellerEntity.this.attackType = 0;
            if (OldMagispellerEntity.this.m_5448_() != null && !OldMagispellerEntity.this.f_19853_.f_46443_) {
                CrashagerEntity ravager = (CrashagerEntity)((EntityType)ModEntityTypes.Crashager.get()).m_20615_(OldMagispellerEntity.this.f_19853_);
                assert (ravager != null);
                ravager.m_6034_(OldMagispellerEntity.this.m_20185_(), OldMagispellerEntity.this.m_20186_(), OldMagispellerEntity.this.m_20189_());
                ravager.m_6710_(OldMagispellerEntity.this.m_5448_());
                ravager.setOwner((Mob)OldMagispellerEntity.this);
                if (OldMagispellerEntity.this.m_5647_() != null) {
                    OldMagispellerEntity.this.f_19853_.m_6188_().m_6546_(ravager.m_20149_(), OldMagispellerEntity.this.f_19853_.m_6188_().m_83489_(OldMagispellerEntity.this.m_5647_().m_5758_()));
                }
                OldMagispellerEntity.this.f_19853_.m_7967_((Entity)ravager);
                OldMagispellerEntity.this.m_20329_((Entity)ravager);
            }
            OldMagispellerEntity.this.setWEEEEEEEEEEEEE(true);
            OldMagispellerEntity.this.setSpinning(false);
        }
    }

    class LifeStealGoal
    extends Goal {
        public LifeStealGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldMagispellerEntity.this.doesAttackMeetNormalRequirements() && OldMagispellerEntity.this.f_19796_.m_188501_() * 75.0f < 0.9f && !OldMagispellerEntity.this.m_20159_();
        }

        public void m_8056_() {
            OldMagispellerEntity.this.setSpinning(true);
            OldMagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_SPIN.get(), 1.0f, 1.0f);
            OldMagispellerEntity.this.attackType = OldMagispellerEntity.this.LIFESTEAL_ATTACK;
        }

        public boolean m_8045_() {
            return OldMagispellerEntity.this.attackTicks <= 139;
        }

        public void m_8037_() {
        }

        public void m_8041_() {
            OldMagispellerEntity.this.attackTicks = 0;
            OldMagispellerEntity.this.attackType = 0;
            OldMagispellerEntity.this.setWavingArms(false);
        }
    }

    class ShootFireballGoal
    extends Goal {
        public ShootFireballGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldMagispellerEntity.this.doesAttackMeetNormalRequirements() && OldMagispellerEntity.this.f_19796_.m_188501_() * 75.0f < 0.9f;
        }

        public void m_8056_() {
            OldMagispellerEntity.this.setWavingArms(true);
            OldMagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_FIREBALL.get(), 2.0f, 1.0f);
            OldMagispellerEntity.this.attackType = OldMagispellerEntity.this.FIREBALL_ATTACK;
        }

        public boolean m_8045_() {
            return OldMagispellerEntity.this.attackTicks <= 50;
        }

        public void m_8037_() {
        }

        public void m_8041_() {
            OldMagispellerEntity.this.attackTicks = 0;
            OldMagispellerEntity.this.attackType = 0;
            OldMagispellerEntity.this.setWavingArms(false);
        }
    }

    class ThrowPotionsGoal
    extends Goal {
        public ThrowPotionsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldMagispellerEntity.this.doesAttackMeetNormalRequirements() && OldMagispellerEntity.this.f_19796_.m_188501_() * 75.0f < 0.9f && !OldMagispellerEntity.this.m_5448_().m_21023_(MobEffects.f_19597_) && OldMagispellerEntity.this.isTargetLowEnoughForGround() && OldMagispellerEntity.this.isTargetCloseEnoughForRange();
        }

        public void m_8056_() {
            OldMagispellerEntity.this.setSpinning(true);
            OldMagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_SPIN.get(), 1.0f, 1.0f);
            OldMagispellerEntity.this.attackType = OldMagispellerEntity.this.POTIONS_ATTACK;
        }

        public boolean m_8045_() {
            return OldMagispellerEntity.this.attackTicks <= 53;
        }

        public void m_8037_() {
        }

        public void m_8041_() {
            OldMagispellerEntity.this.attackTicks = 0;
            OldMagispellerEntity.this.attackType = 0;
            OldMagispellerEntity.this.setSpinning(false);
        }
    }

    class SummonVexesGoal
    extends Goal {
        public SummonVexesGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldMagispellerEntity.this.doesAttackMeetNormalRequirements() && OldMagispellerEntity.this.f_19796_.m_188501_() * 100.0f < 0.9f && OldMagispellerEntity.this.vexCooldown < 1;
        }

        public void m_8056_() {
            OldMagispellerEntity.this.setWavingArms(true);
            OldMagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_SUMMON.get(), 1.0f, 1.0f);
            OldMagispellerEntity.this.attackType = OldMagispellerEntity.this.SUMMON_ATTACK;
        }

        public boolean m_8045_() {
            return OldMagispellerEntity.this.attackTicks <= 20;
        }

        public void m_8037_() {
        }

        public void m_8041_() {
            OldMagispellerEntity.this.attackTicks = 0;
            OldMagispellerEntity.this.attackType = 0;
            OldMagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_CAST_SPELL.get(), 1.0f, 1.0f);
            if (!OldMagispellerEntity.this.f_19853_.f_46443_) {
                ServerLevel serverworld = (ServerLevel)OldMagispellerEntity.this.f_19853_;
                BlockPos blockpos = OldMagispellerEntity.this.m_20183_();
                for (int i = 0; i < 5; ++i) {
                    Vex vex = (Vex)EntityType.f_20491_.m_20615_(OldMagispellerEntity.this.f_19853_);
                    assert (vex != null);
                    vex.m_6034_(OldMagispellerEntity.this.m_20185_(), OldMagispellerEntity.this.m_20186_() + 3.0, OldMagispellerEntity.this.m_20189_());
                    vex.m_6518_((ServerLevelAccessor)serverworld, OldMagispellerEntity.this.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, (SpawnGroupData)null, (CompoundTag)null);
                    vex.m_6710_(OldMagispellerEntity.this.m_5448_());
                    if (OldMagispellerEntity.this.m_5647_() != null) {
                        OldMagispellerEntity.this.f_19853_.m_6188_().m_6546_(vex.m_20149_(), OldMagispellerEntity.this.f_19853_.m_6188_().m_83489_(OldMagispellerEntity.this.m_5647_().m_5758_()));
                    }
                    Objects.requireNonNull(vex.m_21051_(Attributes.f_22276_)).m_22100_(1.0);
                    vex.m_33987_(100);
                    vex.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    vex.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    OldMagispellerEntity.this.f_19853_.m_7967_((Entity)vex);
                }
            }
            OldMagispellerEntity.this.setWavingArms(false);
            OldMagispellerEntity.this.vexCooldown = 900;
        }
    }

    class FangRunGoal
    extends Goal {
        public FangRunGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldMagispellerEntity.this.doesAttackMeetNormalRequirements() && OldMagispellerEntity.this.f_19796_.m_188501_() * 75.0f < 0.9f && OldMagispellerEntity.this.isTargetLowEnoughForGround() && OldMagispellerEntity.this.isTargetCloseEnoughForRange() && !OldMagispellerEntity.this.m_20159_();
        }

        public void m_8056_() {
            OldMagispellerEntity.this.setWavingArms(true);
            OldMagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_FANGRUN.get(), 1.0f, 1.0f);
            OldMagispellerEntity.this.attackType = OldMagispellerEntity.this.FANGRUN_ATTACK;
        }

        public boolean m_8045_() {
            return OldMagispellerEntity.this.attackTicks <= 103;
        }

        public void m_8037_() {
        }

        public void m_8041_() {
            OldMagispellerEntity.this.attackTicks = 0;
            OldMagispellerEntity.this.attackType = 0;
            OldMagispellerEntity.this.setWavingArms(false);
            if (!OldMagispellerEntity.this.f_19853_.f_46443_) {
                OldMagispellerEntity.this.setForcefield(false);
            }
        }
    }

    class DispenserGoal
    extends Goal {
        public DispenserGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldMagispellerEntity.this.doesAttackMeetNormalRequirements() && OldMagispellerEntity.this.f_19796_.m_188501_() * 75.0f < 0.9f && OldMagispellerEntity.this.dispenserCooldown < 1 && OldMagispellerEntity.this.isTargetLowEnoughForGround() && !OldMagispellerEntity.this.m_20159_();
        }

        public void m_8056_() {
            OldMagispellerEntity.this.setSpinning(true);
            OldMagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_SPIN.get(), 1.0f, 1.0f);
            OldMagispellerEntity.this.attackType = OldMagispellerEntity.this.DISPENSER_ATTACK;
        }

        public boolean m_8045_() {
            return OldMagispellerEntity.this.attackTicks <= 17;
        }

        public void m_8037_() {
        }

        public void m_8041_() {
            OldMagispellerEntity.this.attackTicks = 0;
            OldMagispellerEntity.this.attackType = 0;
            OldMagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_DISPENSER.get(), 1.0f, 1.0f);
            OldMagispellerEntity.this.setSpinning(false);
            if (!OldMagispellerEntity.this.f_19853_.f_46443_) {
                DispenserEntity dispenser = (DispenserEntity)((EntityType)ModEntityTypes.Dispenser.get()).m_20615_(OldMagispellerEntity.this.f_19853_);
                assert (dispenser != null);
                dispenser.m_6034_(OldMagispellerEntity.this.m_20185_(), OldMagispellerEntity.this.m_20186_() + 3.0, OldMagispellerEntity.this.m_20189_());
                dispenser.m_20334_((double)(-2 + OldMagispellerEntity.this.f_19796_.m_188503_(5)) * 0.3, 0.3, (double)(-2 + OldMagispellerEntity.this.f_19796_.m_188503_(5)) * 0.3);
                if (OldMagispellerEntity.this.m_5647_() != null) {
                    OldMagispellerEntity.this.f_19853_.m_6188_().m_6546_(dispenser.m_20149_(), OldMagispellerEntity.this.f_19853_.m_6188_().m_83489_(OldMagispellerEntity.this.m_5647_().m_5758_()));
                }
                dispenser.setOwner((Mob)OldMagispellerEntity.this);
                dispenser.setInMotion(true);
                OldMagispellerEntity.this.f_19853_.m_7967_((Entity)dispenser);
            }
            OldMagispellerEntity.this.dispenserCooldown = 300;
        }
    }

    class HealGoal
    extends Goal {
        public HealGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldMagispellerEntity.this.attackType == 0 && !OldMagispellerEntity.this.isFaking() && !OldMagispellerEntity.this.areIllagersNearby() && OldMagispellerEntity.this.f_19796_.m_188501_() * 25.0f < 0.9f && OldMagispellerEntity.this.m_21223_() < OldMagispellerEntity.this.m_21233_() && !OldMagispellerEntity.this.m_21023_(MobEffects.f_19605_) && !OldMagispellerEntity.this.isGoingWEEEEEEEEEEE();
        }

        public void m_8056_() {
            OldMagispellerEntity.this.setWavingArms(true);
            OldMagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_HEAL.get(), 1.0f, 1.0f);
            OldMagispellerEntity.this.attackType = OldMagispellerEntity.this.HEAL_ATTACK;
        }

        public boolean m_8045_() {
            return OldMagispellerEntity.this.attackTicks <= 34;
        }

        public void m_8037_() {
        }

        public void m_8041_() {
            OldMagispellerEntity.this.attackTicks = 0;
            OldMagispellerEntity.this.attackType = 0;
            OldMagispellerEntity.this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 3));
            OldMagispellerEntity.this.setWavingArms(false);
        }
    }

    class CrossbowSpinGoal
    extends Goal {
        public CrossbowSpinGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldMagispellerEntity.this.doesAttackMeetNormalRequirements() && OldMagispellerEntity.this.f_19796_.m_188501_() * 75.0f < 0.9f && !OldMagispellerEntity.this.isGoingWEEEEEEEEEEE();
        }

        public void m_8056_() {
            OldMagispellerEntity.this.setSpinning(true);
            OldMagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_SPIN.get(), 1.0f, 1.0f);
            OldMagispellerEntity.this.attackType = OldMagispellerEntity.this.CROSSBOWSPIN_ATTACK;
            if (OldMagispellerEntity.this.m_5448_() != null && !OldMagispellerEntity.this.f_19853_.f_46443_) {
                OldMagispellerEntity.this.m_20334_((OldMagispellerEntity.this.m_5448_().m_20185_() - OldMagispellerEntity.this.m_20185_()) * 2.0 * 0.16, 0.5, (OldMagispellerEntity.this.m_5448_().m_20189_() - OldMagispellerEntity.this.m_20189_()) * 2.0 * 0.16);
            }
        }

        public boolean m_8045_() {
            return OldMagispellerEntity.this.attackTicks <= 93;
        }

        public void m_8037_() {
        }

        public void m_8041_() {
            OldMagispellerEntity.this.attackTicks = 0;
            OldMagispellerEntity.this.attackType = 0;
            OldMagispellerEntity.this.setSpinning(false);
            OldMagispellerEntity.this.setCrossbowAttacking(false);
        }
    }

    class ClonesGoal
    extends Goal {
        public ClonesGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return OldMagispellerEntity.this.doesAttackMeetNormalRequirements() && OldMagispellerEntity.this.f_19796_.m_188501_() * 50.0f < 0.9f && OldMagispellerEntity.this.m_21223_() < OldMagispellerEntity.this.m_21233_() / 2.0f && OldMagispellerEntity.this.isTargetLowEnoughForGround() && !OldMagispellerEntity.this.m_20159_();
        }

        public void m_8056_() {
            OldMagispellerEntity.this.setWavingArms(true);
            OldMagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_PREPARE_FAKERS.get(), 1.0f, 1.0f);
            OldMagispellerEntity.this.attackType = OldMagispellerEntity.this.CLONES_ATTACK;
        }

        public boolean m_8045_() {
            return OldMagispellerEntity.this.attackTicks <= 51;
        }

        public void m_8037_() {
        }

        public void m_8041_() {
            OldMagispellerEntity.this.attackTicks = 0;
            OldMagispellerEntity.this.attackType = 0;
            if (OldMagispellerEntity.this.m_5448_() != null) {
                if (!OldMagispellerEntity.this.f_19853_.f_46443_) {
                    int i;
                    for (i = 0; i < 11; ++i) {
                        FakeMagispellerEntity clone = (FakeMagispellerEntity)((EntityType)ModEntityTypes.Faker.get()).m_20615_(OldMagispellerEntity.this.f_19853_);
                        assert (clone != null);
                        clone.m_6034_(OldMagispellerEntity.this.m_20182_().f_82479_, OldMagispellerEntity.this.m_20182_().f_82480_, OldMagispellerEntity.this.m_20182_().f_82481_);
                        clone.m_6710_(OldMagispellerEntity.this.m_5448_());
                        clone.m_8061_(EquipmentSlot.MAINHAND, OldMagispellerEntity.this.m_6844_(EquipmentSlot.MAINHAND));
                        clone.m_8061_(EquipmentSlot.OFFHAND, OldMagispellerEntity.this.m_6844_(EquipmentSlot.OFFHAND));
                        clone.m_8061_(EquipmentSlot.HEAD, OldMagispellerEntity.this.m_6844_(EquipmentSlot.HEAD));
                        clone.m_8061_(EquipmentSlot.CHEST, OldMagispellerEntity.this.m_6844_(EquipmentSlot.CHEST));
                        clone.m_8061_(EquipmentSlot.LEGS, OldMagispellerEntity.this.m_6844_(EquipmentSlot.LEGS));
                        clone.m_8061_(EquipmentSlot.FEET, OldMagispellerEntity.this.m_6844_(EquipmentSlot.FEET));
                        clone.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                        clone.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
                        clone.m_21409_(EquipmentSlot.HEAD, 0.0f);
                        clone.m_21409_(EquipmentSlot.CHEST, 0.0f);
                        clone.m_21409_(EquipmentSlot.LEGS, 0.0f);
                        clone.m_21409_(EquipmentSlot.FEET, 0.0f);
                        clone.m_21153_(OldMagispellerEntity.this.m_21223_());
                        clone.setOwner((Mob)OldMagispellerEntity.this);
                        if (OldMagispellerEntity.this.m_8077_()) {
                            clone.m_6593_(OldMagispellerEntity.this.m_7770_());
                        }
                        if (OldMagispellerEntity.this.m_5647_() != null) {
                            OldMagispellerEntity.this.f_19853_.m_6188_().m_6546_(clone.m_20149_(), OldMagispellerEntity.this.f_19853_.m_6188_().m_83489_(OldMagispellerEntity.this.m_5647_().m_5758_()));
                        }
                        OldMagispellerEntity.this.f_19853_.m_7967_((Entity)clone);
                        clone.tryToTeleportToEntity((Entity)OldMagispellerEntity.this.m_5448_());
                        OldMagispellerEntity.this.clones.add(clone);
                    }
                    for (i = 0; i < 5; ++i) {
                        OldMagispellerEntity.this.teleportTowards((Entity)OldMagispellerEntity.this.m_5448_());
                    }
                }
                OldMagispellerEntity.this.distractAttackers((LivingEntity)OldMagispellerEntity.this.clones.get(OldMagispellerEntity.this.f_19796_.m_188503_(OldMagispellerEntity.this.clones.size())));
            }
            OldMagispellerEntity.this.setFaking(true);
            OldMagispellerEntity.this.setVindicatorAttacking(true);
            OldMagispellerEntity.this.setSpinning(false);
        }
    }

    class StareAtTargetGoal
    extends Goal {
        public StareAtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return OldMagispellerEntity.this.m_5448_() != null && !OldMagispellerEntity.this.isActive();
        }

        public boolean m_8045_() {
            return OldMagispellerEntity.this.m_5448_() != null && !OldMagispellerEntity.this.isActive();
        }

        public void m_8037_() {
            OldMagispellerEntity.this.m_21573_().m_26573_();
            if (OldMagispellerEntity.this.m_5448_() != null) {
                OldMagispellerEntity.this.m_21563_().m_24960_((Entity)OldMagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            OldMagispellerEntity.this.f_21344_.m_26573_();
        }
    }
}

