/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.config.IllageAndSpillageConfig;
import com.yellowbrossproductions.illageandspillage.entities.HayArmorEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.util.EffectRegisterer;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class PreserverEntity
extends AbstractIllager {
    private static final EntityDataAccessor<Boolean> TRYING_TO_PROTECT = SynchedEntityData.m_135353_(PreserverEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> JUMP_ANIM_TICKS = SynchedEntityData.m_135353_(PreserverEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity thingToProtect = null;
    private int cooldownTime;

    public PreserverEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new TryToProtectGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.7);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRYING_TO_PROTECT, (Object)false);
        this.f_19804_.m_135372_(JUMP_ANIM_TICKS, (Object)0);
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        if (this.isTryingToProtect()) {
            if (this.getThingToProtect() != null && this.getThingToProtect().m_6084_() && this.getThingToProtect().m_20280_((Entity)this) < 6.0) {
                HayArmorEntity hayArmor = (HayArmorEntity)((EntityType)ModEntityTypes.HayArmor.get()).m_20615_(this.f_19853_);
                assert (hayArmor != null);
                hayArmor.setOwner(this.getThingToProtect());
                hayArmor.m_6034_(this.getThingToProtect().m_20185_(), this.getThingToProtect().m_20186_(), this.getThingToProtect().m_20189_());
                this.f_19853_.m_7967_((Entity)hayArmor);
            }
            this.setTryingToProtect(false);
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_PRESERVER_LAND.get(), 1.0f, 1.0f);
            if (!this.f_19853_.f_46443_) {
                this.setJumpAnimationTick(0);
            }
            this.cooldownTime = 200;
        }
        return false;
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.cooldownTime > 0) {
            --this.cooldownTime;
        }
        if (this.isTryingToProtect()) {
            if (!this.f_19853_.f_46443_) {
                this.setJumpAnimationTick(this.getJumpAnimationTick() + 1);
            }
            this.m_146922_(this.m_6080_());
            this.f_20883_ = this.m_146908_();
            LivingEntity thing = this.getThingToProtect();
            if (this.getThingToProtect() != null) {
                this.m_21563_().m_24960_((Entity)this.getThingToProtect(), 100.0f, 100.0f);
            }
            if (this.getThingToProtect() != null) {
                thing.m_20334_(0.0, thing.m_20184_().f_82480_, 0.0);
            }
            if (this.getJumpAnimationTick() == 20 && this.getThingToProtect() != null) {
                double multiplier = 0.4;
                this.m_20334_((thing.m_20185_() - this.m_20185_()) * multiplier, (thing.m_20186_() - this.m_20186_()) * multiplier, (thing.m_20189_() - this.m_20189_()) * multiplier);
            }
        }
    }

    public int getJumpAnimationTick() {
        return (Integer)this.f_19804_.m_135370_(JUMP_ANIM_TICKS);
    }

    public void setJumpAnimationTick(int tick) {
        this.f_19804_.m_135381_(JUMP_ANIM_TICKS, (Object)tick);
    }

    public boolean isTryingToProtect() {
        return (Boolean)this.f_19804_.m_135370_(TRYING_TO_PROTECT);
    }

    public void setTryingToProtect(boolean trying) {
        this.f_19804_.m_135381_(TRYING_TO_PROTECT, (Object)trying);
    }

    public LivingEntity getThingToProtect() {
        return this.thingToProtect;
    }

    public void setThingToProtect(LivingEntity thingToProtect) {
        this.thingToProtect = thingToProtect;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        this.cooldownTime = 100;
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (p_37849_ != DamageSource.f_19317_ && !p_37849_.m_19384_()) {
            p_37850_ *= 0.5f;
        }
        return super.m_6469_(p_37849_, p_37850_);
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_PRESERVER_AMBIENT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_PRESERVER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_PRESERVER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_PRESERVER_DEATH.get();
    }

    public boolean isSomethingProtectableNearby() {
        return !this.f_19853_.m_6443_(Raider.class, this.m_20191_().m_82400_(12.0), predicate -> (double)predicate.m_20205_() < 1.0 && (double)predicate.m_20206_() < 2.5 && this.m_142582_((Entity)predicate) && predicate.m_6084_() && !(predicate instanceof PreserverEntity) && !predicate.m_21023_((MobEffect)EffectRegisterer.PRESERVED.get()) && !EntityUtil.isMobOnOtherTeam((Entity)predicate, (Mob)this) && !((List)IllageAndSpillageConfig.preserver_cannotProtect.get()).contains(predicate.m_20078_())).isEmpty();
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return this.isTryingToProtect() ? 1.125f : 1.75f;
    }

    class TryToProtectGoal
    extends Goal {
        public boolean m_8036_() {
            return PreserverEntity.this.f_19796_.m_188503_(8) == 0 && PreserverEntity.this.isSomethingProtectableNearby() && PreserverEntity.this.m_20096_() && PreserverEntity.this.cooldownTime < 1 && PreserverEntity.this.f_20916_ < 1 && !PreserverEntity.this.isTryingToProtect();
        }

        public boolean m_8045_() {
            return PreserverEntity.this.isTryingToProtect();
        }

        public TryToProtectGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public void m_8056_() {
            List list = PreserverEntity.this.f_19853_.m_6443_(Raider.class, PreserverEntity.this.m_20191_().m_82400_(6.0), predicate -> (double)predicate.m_20205_() < 1.0 && (double)predicate.m_20206_() < 2.5 && PreserverEntity.this.m_142582_((Entity)predicate) && predicate.m_6084_() && !(predicate instanceof PreserverEntity) && !predicate.m_21023_((MobEffect)EffectRegisterer.PRESERVED.get()) && !EntityUtil.isMobOnOtherTeam((Entity)predicate, (Mob)PreserverEntity.this) && !((List)IllageAndSpillageConfig.preserver_cannotProtect.get()).contains(predicate.m_20078_()));
            if (!list.isEmpty()) {
                LivingEntity thing = (LivingEntity)list.get(PreserverEntity.this.f_19796_.m_188503_(list.size()));
                PreserverEntity.this.setThingToProtect(thing);
                double multiplier = 0.2;
                PreserverEntity.this.m_20334_((thing.m_20185_() - PreserverEntity.this.m_20185_()) * multiplier, 1.2, (thing.m_20189_() - PreserverEntity.this.m_20189_()) * multiplier);
                PreserverEntity.this.setTryingToProtect(true);
                PreserverEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_PRESERVER_JUMP.get(), 1.0f, 1.0f);
            }
        }
    }
}

