/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.config.IllageAndSpillageConfig;
import com.yellowbrossproductions.illageandspillage.entities.CrocofangEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerBoss;
import com.yellowbrossproductions.illageandspillage.entities.IllagerSoulEntity;
import com.yellowbrossproductions.illageandspillage.entities.ImpEntity;
import com.yellowbrossproductions.illageandspillage.entities.MobSpiritEntity;
import com.yellowbrossproductions.illageandspillage.entities.SpiritHandEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.SoulBeamEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.util.EffectRegisterer;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpiritcallerEntity
extends AbstractIllager
implements IllagerBoss {
    private static final EntityDataAccessor<Boolean> SHOULD_DELETE_ITSELF = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NEARBY_ILLAGERS = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> WINGS_FRAME = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> RITUAL = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ARMS_UPWARD = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPINNING = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SOUL_POWER = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FAKING = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FORCEFIELD = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CLAP = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOW_SPIRIT_HANDS = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHARGING_LASER = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOOTING_LASER = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float clientSideWingsAnimationO;
    private float clientSideWingsAnimation;
    private int ritualTicks;
    private int attackTicks;
    private int attackType;
    private int stealSoulsCooldown;
    private int spinDirection;
    private final List<LivingEntity> stolen_mobs = new ArrayList<LivingEntity>();
    private final List<MobSpiritEntity> spirits = new ArrayList<MobSpiritEntity>();
    int SPIRIT_STEAL = 1;
    int SOUL_SWARM = 2;
    int IMP_RISE = 3;
    int SPIRIT_HANDS = 4;
    int SOUL_LASER = 5;
    int ANTICHEESE = 6;
    double chargeX;
    double chargeY;
    double chargeZ;
    double targetX;
    double targetY;
    double targetZ;
    private int chargeTime;
    private int attackCooldown;
    private int spiritSwarmCooldown;
    private int impRiseCooldown;
    private int spiritHandsCooldown;
    private int soulLaserCooldown;
    private int antiCheeseCooldown;
    private int dodgeCooldown;
    private int impAttacks;
    double laserX;
    double laserY;
    double laserZ;
    int stuckTime;
    int lastX;
    int lastY;
    int lastZ;

    public SpiritcallerEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 50;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AntiCheeseGoal());
        this.f_21345_.m_25352_(0, (Goal)new StealSoulsGoal());
        this.f_21345_.m_25352_(0, (Goal)new SoulSwarmGoal());
        this.f_21345_.m_25352_(0, (Goal)new ImpRiseGoal());
        this.f_21345_.m_25352_(0, (Goal)new SpiritHandsGoal());
        this.f_21345_.m_25352_(0, (Goal)new SoulLaserGoal());
        this.f_21345_.m_25352_(1, (Goal)new AlwaysWatchTargetGoal());
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 160.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 96.0);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    public boolean m_6779_(LivingEntity p_213336_1_) {
        if (this.areIllagersNearby()) {
            return false;
        }
        return super.m_6779_(p_213336_1_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOULD_DELETE_ITSELF, (Object)false);
        this.f_19804_.m_135372_(NEARBY_ILLAGERS, (Object)false);
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
        this.f_19804_.m_135372_(WINGS_FRAME, (Object)0);
        this.f_19804_.m_135372_(RITUAL, (Object)false);
        this.f_19804_.m_135372_(ARMS_UPWARD, (Object)false);
        this.f_19804_.m_135372_(SPINNING, (Object)false);
        this.f_19804_.m_135372_(SOUL_POWER, (Object)0);
        this.f_19804_.m_135372_(FAKING, (Object)false);
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(FORCEFIELD, (Object)false);
        this.f_19804_.m_135372_(CLAP, (Object)false);
        this.f_19804_.m_135372_(SHOW_SPIRIT_HANDS, (Object)false);
        this.f_19804_.m_135372_(CHARGING_LASER, (Object)false);
        this.f_19804_.m_135372_(SHOOTING_LASER, (Object)false);
    }

    public void m_7380_(CompoundTag p_37870_) {
        super.m_7380_(p_37870_);
        if (this.isActive()) {
            p_37870_.m_128379_("active", true);
        }
        p_37870_.m_128405_("SoulPower", this.getSoulPower());
    }

    public void m_7378_(CompoundTag p_37862_) {
        super.m_7378_(p_37862_);
        this.setActive(p_37862_.m_128471_("active"));
        this.setSoulPower(p_37862_.m_128451_("SoulPower"));
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public void m_8119_() {
        this.updateMobList();
        List list = this.f_19853_.m_6443_(Raider.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.m_37886_() && !(predicate instanceof IllagerBoss));
        if (((Boolean)IllageAndSpillageConfig.spiritcaller_forcefield.get()).booleanValue() && this.m_37886_()) {
            if (!this.f_19853_.f_46443_) {
                this.setIllagersNearby(!list.isEmpty());
            }
            if (!list.isEmpty()) {
                this.m_6710_(null);
            }
        }
        if (this.m_37886_()) {
            if (this.m_37885_() != null && this.m_37885_().m_37771_() == 7 && this.shouldRemoveItself() && ((Boolean)IllageAndSpillageConfig.spiritcaller_onlyOneAllowed.get()).booleanValue()) {
                this.m_37885_().m_37740_((Raider)this, true);
                if (!this.f_19853_.f_46443_) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
            if (this.m_37885_() != null) {
                this.m_37885_().m_37776_();
            }
        }
        if (this.areIllagersNearby()) {
            this.stopAttackersFromAttacking();
        }
        if (this.ritualTicks > 0 && !this.isActive() && this.m_6084_()) {
            ++this.ritualTicks;
            if (this.ritualTicks == 30) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_INTRO.get(), 2.0f, 1.0f);
                if (!this.f_19853_.f_46443_) {
                    this.setRitual(true);
                }
            }
            if (this.ritualTicks >= 145) {
                if (!this.f_19853_.f_46443_) {
                    this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Explosion.BlockInteraction.NONE);
                }
                this.attackCooldown = 100;
                this.setActive(true);
                this.setRitual(false);
            }
        }
        this.attackTicks = this.attackType > 0 ? ++this.attackTicks : 0;
        if (this.stealSoulsCooldown > 0 && this.stolen_mobs.isEmpty()) {
            --this.stealSoulsCooldown;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.isActive() && this.attackType == 0 && this.m_5448_() != null && this.f_19797_ % 20 == 10) {
            if (!this.m_142582_((Entity)this.m_5448_())) {
                ++this.stuckTime;
            } else if (this.stuckTime > 0) {
                --this.stuckTime;
            }
            this.lastX = this.m_20183_().m_123341_();
            this.lastY = this.m_20183_().m_123342_();
            this.lastZ = this.m_20183_().m_123343_();
        }
        if (this.spiritSwarmCooldown > 0) {
            --this.spiritSwarmCooldown;
        }
        if (this.impRiseCooldown > 0) {
            --this.impRiseCooldown;
        }
        if (this.spiritHandsCooldown > 0) {
            --this.spiritHandsCooldown;
        }
        if (this.soulLaserCooldown > 0) {
            --this.soulLaserCooldown;
        }
        if (this.m_6084_()) {
            if (this.attackType == this.SPIRIT_STEAL && !this.stolen_mobs.isEmpty()) {
                for (LivingEntity entity : this.stolen_mobs) {
                    entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 0.0f);
                    entity.m_20334_(-0.5 + this.f_19796_.m_188500_(), entity.m_20184_().f_82480_, -0.5 + this.f_19796_.m_188500_());
                }
            }
            if (this.attackType == this.SOUL_SWARM) {
                if (this.attackTicks > 10 && this.attackTicks <= 55) {
                    for (int i = 0; i < this.getSoulPower() + 1; ++i) {
                        if (this.f_19853_.f_46443_) continue;
                        IllagerSoulEntity soul = (IllagerSoulEntity)((EntityType)ModEntityTypes.IllagerSoul.get()).m_20615_(this.f_19853_);
                        assert (soul != null);
                        soul.m_6034_(this.m_20185_() + (double)(-10 - this.getSoulPower() + this.f_19796_.m_188503_(20 + this.getSoulPower() * 2)), this.m_20186_() + (double)(-1 + this.f_19796_.m_188503_(10 + this.getSoulPower() * 2)), this.m_20189_() + (double)(-10 - this.getSoulPower() + this.f_19796_.m_188503_(20 + this.getSoulPower() * 2)));
                        soul.setOwner((LivingEntity)this);
                        soul.setAngelOrDevil(this.f_19796_.m_188499_());
                        soul.m_6710_(this.m_5448_());
                        soul.m_20334_(0.0, 0.1, 0.0);
                        if (this.m_5647_() != null) {
                            this.f_19853_.m_6188_().m_6546_(soul.m_20149_(), this.f_19853_.m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        this.f_19853_.m_7967_((Entity)soul);
                    }
                }
                if (this.attackTicks == 18 && !this.f_19853_.f_46443_) {
                    this.setArmsUpward(false);
                    this.setSpinning(true);
                }
                if (this.attackTicks > 18 && this.attackTicks < 55 && !this.f_19853_.f_46443_) {
                    this.setFaking(this.f_19796_.m_188499_());
                }
                if (this.attackTicks == 55) {
                    if (!this.f_19853_.f_46443_) {
                        this.setSpinning(false);
                        this.setArmsUpward(true);
                        this.setFaking(true);
                    }
                    this.m_20334_(0.0, 0.3, 0.0);
                }
            }
            if (this.attackType == this.IMP_RISE) {
                if (this.attackTicks == 37) {
                    this.setArmsUpward(false);
                    this.setClap(true);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_CLAP.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks == 40) {
                    this.impAttacks = this.f_19796_.m_188503_(3) + 1;
                    if (this.impAttacks == 1) {
                        this.createLineImps();
                    }
                    if (this.impAttacks == 2) {
                        this.createRandomImps();
                    }
                    if (this.impAttacks == 3) {
                        this.createRingImps();
                    }
                }
                if (this.attackTicks == 50) {
                    this.setArmsUpward(true);
                    this.setClap(false);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_IMPRISE.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks == 87) {
                    this.setArmsUpward(false);
                    this.setClap(true);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_CLAP.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks == 90) {
                    this.impAttacks = this.f_19796_.m_188503_(3) + 1;
                    if (this.impAttacks == 1) {
                        this.createLineImps();
                    }
                    if (this.impAttacks == 2) {
                        this.createRandomImps();
                    }
                    if (this.impAttacks == 3) {
                        this.createRingImps();
                    }
                }
                if (this.attackTicks == 100) {
                    this.setArmsUpward(true);
                    this.setClap(false);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_IMPRISE.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks == 137) {
                    this.setArmsUpward(false);
                    this.setClap(true);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_CLAP.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks == 140) {
                    this.impAttacks = this.f_19796_.m_188503_(3) + 1;
                    if (this.impAttacks == 1) {
                        this.createLineImps();
                    }
                    if (this.impAttacks == 2) {
                        this.createRandomImps();
                    }
                    if (this.impAttacks == 3) {
                        this.createRingImps();
                    }
                }
            }
            if (this.attackType == this.SPIRIT_HANDS) {
                if (this.attackTicks == 19) {
                    this.setShowSpiritHands(true);
                }
                if (this.attackTicks == 37) {
                    this.setSpinning(false);
                    this.setClap(true);
                }
                if (this.attackTicks == 40) {
                    this.setShowSpiritHands(false);
                    SpiritHandEntity hand1 = (SpiritHandEntity)((EntityType)ModEntityTypes.SpiritHand.get()).m_20615_(this.f_19853_);
                    assert (hand1 != null);
                    hand1.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                    hand1.setGoodOrEvil(true);
                    hand1.m_20334_((-0.5 + this.f_19796_.m_188500_()) / 2.0, (-0.5 + this.f_19796_.m_188500_()) / 2.0, (-0.5 + this.f_19796_.m_188500_()) / 2.0);
                    hand1.setOwner((LivingEntity)this);
                    hand1.m_6710_(this.m_5448_());
                    hand1.setPower(this.getSoulPower());
                    if (this.m_5647_() != null) {
                        this.f_19853_.m_6188_().m_6546_(hand1.m_20149_(), this.f_19853_.m_6188_().m_83489_(this.m_5647_().m_5758_()));
                    }
                    this.f_19853_.m_7967_((Entity)hand1);
                    SpiritHandEntity hand2 = (SpiritHandEntity)((EntityType)ModEntityTypes.SpiritHand.get()).m_20615_(this.f_19853_);
                    assert (hand2 != null);
                    hand2.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                    hand2.setGoodOrEvil(false);
                    hand2.m_20334_((-0.5 + this.f_19796_.m_188500_()) / 2.0, (-0.5 + this.f_19796_.m_188500_()) / 2.0, (-0.5 + this.f_19796_.m_188500_()) / 2.0);
                    hand2.setOwner((LivingEntity)this);
                    hand2.m_6710_(this.m_5448_());
                    if (this.m_5647_() != null) {
                        this.f_19853_.m_6188_().m_6546_(hand2.m_20149_(), this.f_19853_.m_6188_().m_83489_(this.m_5647_().m_5758_()));
                    }
                    hand2.setPower(this.getSoulPower());
                    this.f_19853_.m_7967_((Entity)hand2);
                }
            }
            if (this.attackType == this.SOUL_LASER) {
                SoulBeamEntity beam = null;
                if (this.m_5448_() != null && this.attackTicks < 85) {
                    this.setLaserPosition(this.m_5448_().m_20185_(), this.m_5448_().m_20186_() + (double)this.m_5448_().m_20192_(), this.m_5448_().m_20189_());
                }
                if (this.laserX != 0.0 || this.laserY != 0.0 || this.laserZ != 0.0) {
                    this.m_21563_().m_24950_(this.laserX, this.laserY, this.laserZ, 100.0f, 100.0f);
                }
                if (this.attackTicks == 100) {
                    this.setChargingLaser(false);
                    this.setShootingLaser(true);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_LASER.get(), 2.0f, 1.0f);
                    if (!this.f_19853_.f_46443_) {
                        beam = new SoulBeamEntity((EntityType<? extends SoulBeamEntity>)((EntityType)ModEntityTypes.SoulBeam.get()), this.f_19853_, (LivingEntity)this, this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0), this.m_20186_() + 1.0, this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0), (float)((double)(this.f_20885_ + 90.0f) * Math.PI / 180.0), (float)((double)(-this.m_146909_()) * Math.PI / 180.0), 40, this.getSoulPower());
                        this.f_19853_.m_7967_((Entity)beam);
                    }
                }
                if (this.attackTicks >= 100) {
                    this.m_20334_(0.0, 0.0, 0.0);
                    if (beam != null) {
                        float radius2 = 1.1f;
                        double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                        double y = this.m_20186_() + 1.0 + (double)radius2 * Math.sin((double)(-this.m_146909_()) * Math.PI / 180.0);
                        double z = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                        beam.m_6034_(x, y, z);
                        float yaw = this.f_20885_ + 90.0f;
                        float pitch = -this.m_146909_();
                        beam.setYaw((float)((double)yaw * Math.PI / 180.0));
                        beam.setPitch((float)((double)pitch * Math.PI / 180.0));
                        beam.setPower(this.getSoulPower());
                    }
                }
            }
            if (this.attackType == this.ANTICHEESE) {
                this.m_20334_(0.0, 0.4, 0.0);
            }
        }
        if (this.m_6084_()) {
            if (this.chargeX != 0.0 && this.chargeY != 0.0 && this.chargeZ != 0.0) {
                ++this.chargeTime;
                this.m_20334_(this.chargeX, this.chargeY, this.chargeZ);
                if (!this.f_19853_.f_46443_) {
                    this.setCharging(true);
                }
                if (this.m_20185_() - this.targetX < 1.0 && this.m_20185_() - this.targetX > -1.0 && this.m_20186_() - this.targetY < 1.0 && this.m_20186_() - this.targetY > -1.0 && this.m_20189_() - this.targetZ < 1.0 && this.m_20189_() - this.targetZ > -1.0 || this.chargeTime > 60) {
                    if (!this.f_19853_.f_46443_) {
                        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Explosion.BlockInteraction.NONE);
                        this.setFaking(false);
                    }
                    this.setCharge(0.0, 0.0, 0.0);
                    this.setTargetPosition(0.0, 0.0, 0.0);
                    this.m_20334_(0.0, 0.5, 0.0);
                }
            } else {
                this.chargeTime = 0;
                if (!this.f_19853_.f_46443_) {
                    this.setCharging(false);
                }
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.setForcefield(!this.stolen_mobs.isEmpty());
        }
        if (this.isActive()) {
            List projectiles = this.f_19853_.m_6443_(Projectile.class, this.m_20191_().m_82400_(10.0), predicate -> this.m_20280_((Entity)predicate) <= 90.0);
            for (Projectile thing : projectiles) {
                Vec3 aActualMotion = new Vec3(thing.m_20185_() - thing.f_19854_, thing.m_20186_() - thing.f_19791_, thing.m_20189_() - thing.f_19856_);
                if (aActualMotion.m_82553_() < 0.1 || thing.f_19797_ <= 1) continue;
                float dot = (float)thing.m_20184_().m_82541_().m_82526_(this.m_20182_().m_82520_(0.0, 1.5, 0.0).m_82546_(thing.m_20182_()).m_82541_());
                if (this.dodgeCooldown >= 1) continue;
                if ((double)dot > 0.94) {
                    Vec3 dodgeVec = thing.m_20184_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_(1.2);
                    Vec3 newPosLeft = this.m_20318_(1.0f).m_82549_(dodgeVec.m_82490_(2.0));
                    Vec3 newPosRight = this.m_20318_(1.0f).m_82549_(dodgeVec.m_82490_(-2.0));
                    Vec3 diffLeft = newPosLeft.m_82546_(thing.m_20182_());
                    Vec3 diffRight = newPosRight.m_82546_(thing.m_20182_());
                    if (diffRight.m_82526_(thing.m_20184_()) > diffLeft.m_82526_(thing.m_20184_())) {
                        dodgeVec = dodgeVec.m_82490_(-1.0);
                    }
                    this.m_20256_(this.m_20184_().m_82549_(dodgeVec.m_82490_(0.5)));
                }
                this.dodgeCooldown = 10;
            }
            if (this.dodgeCooldown > 0) {
                --this.dodgeCooldown;
            }
        }
        super.m_8119_();
        if (this.isActive() || this.isRitual()) {
            this.m_146922_(this.m_6080_());
            this.f_20883_ = this.m_146908_();
        }
        if (this.isSpinning()) {
            ++this.spinDirection;
            if (this.spinDirection > 4) {
                this.spinDirection = 1;
            }
            this.f_20883_ = this.spinDirection * 90;
        }
        if (this.isChargingLaser() && this.f_19853_.f_46443_) {
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.8, this.m_20186_() + 2.5, this.m_20189_() - (double)f2 * 0.8, 0.1, 0.1, 0.2);
        }
        if (this.isActive()) {
            this.m_20242_(true);
            this.nextWingsFrame();
            if (this.getWingsFrames() == 12 && this.m_6084_()) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_WINGS.get(), 2.0f, 1.0f);
            }
            if (this.getWingsFrames() >= 25) {
                this.resetWingsFrame();
            }
            if (this.f_19853_.f_46443_) {
                this.clientSideWingsAnimationO = this.clientSideWingsAnimation;
                this.clientSideWingsAnimation = Mth.m_14036_((float)(this.clientSideWingsAnimation + 1.0f), (float)0.0f, (float)25.0f);
            }
            if (!this.isCharging() && this.m_5448_() != null) {
                LivingEntity entity = this.m_5448_();
                double x = this.m_20185_() - entity.m_20185_();
                double y = this.m_20186_() - entity.m_20186_();
                double z = this.m_20189_() - entity.m_20189_();
                double d = Math.sqrt(x * x + y * y + z * z);
                float power = 0.08f;
                double motionX = this.m_20184_().f_82479_ - x / d * (double)power * 0.2;
                double motionY = this.m_20184_().f_82480_ - y / d * (double)power * 0.2;
                double motionZ = this.m_20184_().f_82481_ - z / d * (double)power * 0.2;
                if (this.m_20280_((Entity)entity) > 120.0) {
                    this.m_20334_(motionX, motionY, motionZ);
                }
            }
            if (!this.isCharging()) {
                if (this.m_5448_() != null) {
                    if (this.f_19853_.m_8055_(this.m_20183_().m_6625_(5)) != Blocks.f_50016_.m_49966_() || this.f_19853_.m_8055_(this.m_20183_().m_6625_(4)) != Blocks.f_50016_.m_49966_() || this.f_19853_.m_8055_(this.m_20183_().m_6625_(3)) != Blocks.f_50016_.m_49966_() || this.f_19853_.m_8055_(this.m_20183_().m_6625_(2)) != Blocks.f_50016_.m_49966_() || this.f_19853_.m_8055_(this.m_20183_().m_6625_(1)) != Blocks.f_50016_.m_49966_()) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04, 0.0));
                    } else if (this.m_20184_().f_82480_ > 0.0) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
                    }
                } else if (this.f_19853_.m_8055_(this.m_20183_().m_6625_(1)) != Blocks.f_50016_.m_49966_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04, 0.0));
                } else {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
                }
            }
        }
        List attackingMobs = this.f_19853_.m_6443_(Mob.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.m_5448_() == this);
        if (!this.stolen_mobs.isEmpty() && !this.isArmsUpward()) {
            LivingEntity toBeAttacked = this.stolen_mobs.get(this.f_19796_.m_188503_(this.stolen_mobs.size()));
            for (Mob attacker : attackingMobs) {
                if (this.f_19796_.m_188503_(2) == 0 && !this.spirits.isEmpty()) {
                    attacker.m_6710_((LivingEntity)this.spirits.get(this.f_19796_.m_188503_(this.spirits.size())));
                    continue;
                }
                if (this.canStolenMobBeAttacked(toBeAttacked, (LivingEntity)attacker)) {
                    attacker.m_6710_(toBeAttacked);
                    continue;
                }
                if (!this.spirits.isEmpty()) {
                    attacker.m_6710_((LivingEntity)this.spirits.get(this.f_19796_.m_188503_(this.spirits.size())));
                    continue;
                }
                attacker.m_6710_(null);
            }
        }
    }

    public boolean m_20329_(Entity p_20330_) {
        if (p_20330_ instanceof CrocofangEntity || p_20330_ instanceof Ravager) {
            return super.m_20329_(p_20330_);
        }
        return false;
    }

    protected void createLineImps() {
        if (this.m_5448_() != null) {
            LivingEntity livingentity = this.m_5448_();
            double d0 = Math.min(livingentity.m_20186_(), this.m_20186_() - 5.0);
            double d1 = Math.max(livingentity.m_20186_(), this.m_20186_() - 5.0) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.m_20189_()), (double)(livingentity.m_20185_() - this.m_20185_()));
            for (int l = 0; l < 16; ++l) {
                double d2 = 1.25 * (double)(l + 1);
                int j = 1 * l;
                this.createSpellEntity(this.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, j, l);
            }
        }
    }

    protected void createRandomImps() {
        if (this.m_5448_() != null) {
            LivingEntity livingentity = this.m_5448_();
            double d0 = Math.min(livingentity.m_20186_(), this.m_20186_() - 5.0);
            double d1 = Math.max(livingentity.m_20186_(), this.m_20186_() - 5.0) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.m_20189_()), (double)(livingentity.m_20185_() - this.m_20185_()));
            for (int l = 0; l < 30; ++l) {
                double d2 = 1.25 * (double)(l + 1);
                int j = 1 * l;
                this.createSpellEntity(this.m_20185_() + (double)(-15 + this.f_19796_.m_188503_(30)), this.m_20189_() + (double)(-15 + this.f_19796_.m_188503_(30)), d0, d1, f, j, l);
            }
        }
    }

    protected void createRingImps() {
        if (this.m_5448_() != null) {
            LivingEntity livingentity = this.m_5448_();
            double d0 = Math.min(livingentity.m_20186_(), this.m_20186_() - 5.0);
            double d1 = Math.max(livingentity.m_20186_(), this.m_20186_() - 5.0) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.m_20189_()), (double)(livingentity.m_20185_() - this.m_20185_()));
            int j = 1;
            this.createSpellEntity(livingentity.m_20185_() - 3.0, livingentity.m_20189_() - 0.0, d0, d1, f, j, 0);
            this.createSpellEntity(livingentity.m_20185_() - 2.0, livingentity.m_20189_() - -1.0, d0, d1, f, j, 1);
            this.createSpellEntity(livingentity.m_20185_() - 1.0, livingentity.m_20189_() - -2.0, d0, d1, f, j, 2);
            this.createSpellEntity(livingentity.m_20185_() - 0.0, livingentity.m_20189_() - -3.0, d0, d1, f, j, 3);
            this.createSpellEntity(livingentity.m_20185_() - -1.0, livingentity.m_20189_() - -2.0, d0, d1, f, j, 4);
            this.createSpellEntity(livingentity.m_20185_() - -2.0, livingentity.m_20189_() - -1.0, d0, d1, f, j, 5);
            this.createSpellEntity(livingentity.m_20185_() - -3.0, livingentity.m_20189_() - 0.0, d0, d1, f, j, 6);
            this.createSpellEntity(livingentity.m_20185_() - -2.0, livingentity.m_20189_() - 1.0, d0, d1, f, j, 7);
            this.createSpellEntity(livingentity.m_20185_() - -1.0, livingentity.m_20189_() - 2.0, d0, d1, f, j, 8);
            this.createSpellEntity(livingentity.m_20185_() - 0.0, livingentity.m_20189_() - 3.0, d0, d1, f, j, 9);
            this.createSpellEntity(livingentity.m_20185_() - 1.0, livingentity.m_20189_() - 2.0, d0, d1, f, j, 10);
            this.createSpellEntity(livingentity.m_20185_() - 2.0, livingentity.m_20189_() - 1.0, d0, d1, f, j, 11);
            this.createSpellEntity(livingentity.m_20185_() - 0.0, livingentity.m_20189_() - 0.0, d0, d1, f, j, 12);
        }
    }

    private void createSpellEntity(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_, int time) {
        BlockPos blockpos = new BlockPos(p_190876_1_, p_190876_7_, p_190876_3_);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)this.f_19853_, blockpos1, Direction.UP)) continue;
            if (!this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_190876_5_) - 1);
        if (flag) {
            ImpEntity imp = (ImpEntity)((EntityType)ModEntityTypes.Imp.get()).m_20615_(this.f_19853_);
            assert (imp != null);
            imp.m_6034_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + d0, (double)blockpos.m_123343_() + 0.5);
            imp.setOwner((LivingEntity)this);
            imp.setPower(this.getSoulPower());
            imp.m_6710_(this.m_5448_());
            imp.setWaitTime(time);
            imp.m_6842_(true);
            if (this.m_5647_() != null) {
                this.f_19853_.m_6188_().m_6546_(imp.m_20149_(), this.f_19853_.m_6188_().m_83489_(this.m_5647_().m_5758_()));
            }
            this.f_19853_.m_7967_((Entity)imp);
        }
    }

    public boolean m_6128_() {
        return this.isCharging() || this.spiritSwarmCooldown > 140;
    }

    public boolean canStolenMobBeAttacked(LivingEntity entity, LivingEntity attacker) {
        if (((List)IllageAndSpillageConfig.spiritcaller_wontAttack.get()).contains(entity.m_20078_())) {
            return false;
        }
        if (entity.m_5647_() != null) {
            return entity.m_5647_().m_6260_();
        }
        if (entity instanceof MobSpiritEntity) {
            return ((MobSpiritEntity)entity).getOwner() != attacker;
        }
        return attacker != entity;
    }

    public void m_6667_(DamageSource p_37847_) {
        if (this.m_37886_() && this.m_37885_() != null) {
            this.m_37885_().f_37673_ = 0L;
        }
        if (this.isActive()) {
            if (!this.f_19853_.f_46443_) {
                this.attackTicks = 0;
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            }
            if (this.f_20889_ > 0) {
                this.f_20889_ = 10000;
            }
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_DEATHANIMATION.get(), 3.0f, 1.0f);
        } else {
            super.m_6667_(p_37847_);
        }
    }

    protected void m_6153_() {
        if (this.isActive()) {
            this.setCharging(false);
            this.setFaking(false);
            this.setSpinning(false);
            this.setArmsUpward(false);
            this.setClap(false);
            ++this.f_20919_;
            this.m_20334_(0.0, 0.05, 0.0);
            List list1 = this.f_19853_.m_6443_(MobSpiritEntity.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == this);
            List list2 = this.f_19853_.m_6443_(IllagerSoulEntity.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == this);
            List list3 = this.f_19853_.m_6443_(ImpEntity.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == this);
            List list4 = this.f_19853_.m_6443_(SpiritHandEntity.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == this);
            for (MobSpiritEntity spirit : list1) {
                spirit.m_6074_();
            }
            for (IllagerSoulEntity soul : list2) {
                soul.m_6074_();
            }
            for (ImpEntity imp : list3) {
                imp.m_146870_();
            }
            for (SpiritHandEntity hand : list4) {
                hand.m_6074_();
            }
            if (this.f_20919_ == 131) {
                if (!this.f_19853_.f_46443_) {
                    this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f, Explosion.BlockInteraction.NONE);
                }
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_DEATH.get(), 3.0f, 1.0f);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_DESCENT.get(), 3.0f, 1.0f);
                super.m_6667_(DamageSource.f_19318_);
                if (!this.f_19853_.f_46443_) {
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
            }
        } else {
            super.m_6153_();
        }
    }

    public int getAttackTicks() {
        return this.attackTicks;
    }

    public int getAttackType() {
        return this.attackType;
    }

    public boolean isForcefieldProtected() {
        return (Boolean)this.f_19804_.m_135370_(FORCEFIELD);
    }

    public void setForcefield(boolean forcefield) {
        this.f_19804_.m_135381_(FORCEFIELD, (Object)forcefield);
    }

    public boolean shouldRemoveItself() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_DELETE_ITSELF);
    }

    public void setShouldDeleteItself(boolean shouldDelete) {
        this.f_19804_.m_135381_(SHOULD_DELETE_ITSELF, (Object)shouldDelete);
    }

    public boolean areIllagersNearby() {
        return (Boolean)this.f_19804_.m_135370_(NEARBY_ILLAGERS);
    }

    public void setIllagersNearby(boolean illagersNearby) {
        this.f_19804_.m_135381_(NEARBY_ILLAGERS, (Object)illagersNearby);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(ACTIVE, (Object)active);
    }

    public void nextWingsFrame() {
        this.f_19804_.m_135381_(WINGS_FRAME, (Object)(this.getWingsFrames() + 1));
    }

    public int getWingsFrames() {
        return (Integer)this.f_19804_.m_135370_(WINGS_FRAME);
    }

    public boolean isRitual() {
        return (Boolean)this.f_19804_.m_135370_(RITUAL);
    }

    public void setRitual(boolean ritual) {
        this.f_19804_.m_135381_(RITUAL, (Object)ritual);
    }

    public boolean isArmsUpward() {
        return (Boolean)this.f_19804_.m_135370_(ARMS_UPWARD);
    }

    public void setArmsUpward(boolean arms) {
        this.f_19804_.m_135381_(ARMS_UPWARD, (Object)arms);
    }

    public void setSoulPower(int souls) {
        this.f_19804_.m_135381_(SOUL_POWER, (Object)souls);
    }

    public int getSoulPower() {
        return (Integer)this.f_19804_.m_135370_(SOUL_POWER);
    }

    public void resetWingsFrame() {
        this.f_19804_.m_135381_(WINGS_FRAME, (Object)0);
        if (this.f_19853_.f_46443_) {
            this.clientSideWingsAnimation = 0.0f;
        }
    }

    public boolean isSpinning() {
        return (Boolean)this.f_19804_.m_135370_(SPINNING);
    }

    public void setSpinning(boolean spinning) {
        this.f_19804_.m_135381_(SPINNING, (Object)spinning);
    }

    public boolean isFaking() {
        return (Boolean)this.f_19804_.m_135370_(FAKING);
    }

    public void setFaking(boolean faking) {
        this.f_19804_.m_135381_(FAKING, (Object)faking);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charge) {
        this.f_19804_.m_135381_(CHARGING, (Object)charge);
    }

    public boolean isClap() {
        return (Boolean)this.f_19804_.m_135370_(CLAP);
    }

    public void setClap(boolean spinning) {
        this.f_19804_.m_135381_(CLAP, (Object)spinning);
    }

    public float getWingsAnimationScale(float p_29570_) {
        return Mth.m_14179_((float)p_29570_, (float)this.clientSideWingsAnimationO, (float)this.clientSideWingsAnimation) / 3.0f;
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean shouldShowSpiritHands() {
        return (Boolean)this.f_19804_.m_135370_(SHOW_SPIRIT_HANDS);
    }

    public void setShowSpiritHands(boolean hands) {
        this.f_19804_.m_135381_(SHOW_SPIRIT_HANDS, (Object)hands);
    }

    public boolean isChargingLaser() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING_LASER);
    }

    public void setChargingLaser(boolean chargingLaser) {
        this.f_19804_.m_135381_(CHARGING_LASER, (Object)chargingLaser);
    }

    public boolean isShootingLaser() {
        return (Boolean)this.f_19804_.m_135370_(SHOOTING_LASER);
    }

    public void setShootingLaser(boolean laser) {
        this.f_19804_.m_135381_(SHOOTING_LASER, (Object)laser);
    }

    public void updateMobList() {
        Object mob;
        int i;
        if (!this.stolen_mobs.isEmpty()) {
            for (i = 0; i < this.stolen_mobs.size(); ++i) {
                mob = this.stolen_mobs.get(i);
                if (mob.m_6084_()) continue;
                this.stolen_mobs.remove(i);
                --i;
            }
        }
        if (!this.spirits.isEmpty()) {
            for (i = 0; i < this.spirits.size(); ++i) {
                mob = this.spirits.get(i);
                if (mob.m_6084_()) continue;
                if (mob.getOriginalMob() != null) {
                    this.stolen_mobs.removeIf(arg_0 -> SpiritcallerEntity.lambda$updateMobList$7((MobSpiritEntity)((Object)mob), arg_0));
                }
                this.spirits.remove(i);
                --i;
            }
        }
    }

    public void makeParticles() {
        for (int i = 0; i < 250; ++i) {
            double d0 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
            double d1 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
            double d2 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (!this.isActive() && p_37849_ != DamageSource.f_19317_) {
            p_37850_ = 0.0f;
            if (p_37849_.m_7639_() != null && this.ritualTicks == 0 && !this.areIllagersNearby()) {
                this.ritualTicks = 1;
                if (this.m_37886_() && this.m_37885_() != null) {
                    this.m_37885_().f_37673_ = 0L;
                }
            }
        }
        if ((this.areIllagersNearby() || this.isForcefieldProtected()) && p_37849_ != DamageSource.f_19317_) {
            return false;
        }
        if (p_37849_.m_7639_() instanceof IllagerSoulEntity && ((IllagerSoulEntity)p_37849_.m_7639_()).getOwner() == this) {
            return false;
        }
        if (p_37849_.m_19360_()) {
            p_37850_ /= 2.0f;
        }
        return super.m_6469_(p_37849_, p_37850_);
    }

    public int getRitualTicks() {
        return this.ritualTicks;
    }

    public boolean m_21532_() {
        return true;
    }

    public void stopAttackersFromAttacking() {
        List list = this.f_19853_.m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
        for (Mob attacker : list) {
            if (attacker.m_21188_() == this) {
                attacker.m_6703_(null);
            }
            if (attacker.m_5448_() != this) continue;
            attacker.m_6710_(null);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        if (p_213386_3_ == MobSpawnType.EVENT) {
            this.setShouldDeleteItself(true);
        }
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_CELEBRATE.get();
    }

    protected SoundEvent m_7515_() {
        if (this.isRitual()) {
            return null;
        }
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        if (this.isActive()) {
            return null;
        }
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_DEATH.get();
    }

    public boolean doesAttackMeetNormalRequirements() {
        return this.attackType == 0 && !this.areIllagersNearby() && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.isActive() && !this.isFaking();
    }

    public boolean isTargetOnGround() {
        if (this.m_5448_() != null) {
            return this.m_5448_().m_20096_();
        }
        return false;
    }

    public boolean areStealableMobsNearby() {
        List list = this.f_19853_.m_6443_(Mob.class, this.m_20191_().m_82400_(15.0), predicate -> ((List)IllageAndSpillageConfig.spiritcaller_stealableMobs.get()).contains(predicate.m_20078_()) && !predicate.m_20147_() && predicate != this);
        return !list.isEmpty();
    }

    public boolean checkForStolenMobs() {
        return this.stolen_mobs.isEmpty() || !this.areStolenMobsNearby();
    }

    public boolean areStolenMobsNearby() {
        List list = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(100.0), predicate -> ((List)IllageAndSpillageConfig.spiritcaller_stealableMobs.get()).contains(predicate.m_20078_()) && !predicate.m_20147_() && predicate.m_21023_((MobEffect)EffectRegisterer.DISABILITY.get()));
        return !list.isEmpty();
    }

    public void setCharge(double x, double y, double z) {
        this.chargeX = x;
        this.chargeY = y;
        this.chargeZ = z;
    }

    public void setTargetPosition(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public void setLaserPosition(double x, double y, double z) {
        this.laserX = x;
        this.laserY = y;
        this.laserZ = z;
    }

    private static /* synthetic */ boolean lambda$updateMobList$7(MobSpiritEntity mob, LivingEntity original) {
        return original == mob.getOriginalMob();
    }

    class AntiCheeseGoal
    extends Goal {
        AntiCheeseGoal() {
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.stuckTime > 5 && SpiritcallerEntity.this.attackType == 0 && !SpiritcallerEntity.this.areIllagersNearby() && SpiritcallerEntity.this.m_5448_() != null && SpiritcallerEntity.this.isActive() && !SpiritcallerEntity.this.isFaking() && SpiritcallerEntity.this.f_19796_.m_188503_(8) == 0 && SpiritcallerEntity.this.antiCheeseCooldown < 1 && SpiritcallerEntity.this.attackCooldown < 1;
        }

        public boolean m_8045_() {
            boolean otherCheck = SpiritcallerEntity.this.m_5448_() != null && !SpiritcallerEntity.this.m_142582_((Entity)SpiritcallerEntity.this.m_5448_());
            return SpiritcallerEntity.this.f_19853_.m_8055_(SpiritcallerEntity.this.m_20183_().m_7494_()) == Blocks.f_50016_.m_49966_() && SpiritcallerEntity.this.f_19853_.m_8055_(SpiritcallerEntity.this.m_20183_().m_7494_().m_7494_()) == Blocks.f_50016_.m_49966_() && SpiritcallerEntity.this.f_19853_.m_8055_(SpiritcallerEntity.this.m_20183_().m_7494_().m_7494_().m_7494_()) == Blocks.f_50016_.m_49966_() && SpiritcallerEntity.this.m_20183_().m_123341_() != SpiritcallerEntity.this.lastX && SpiritcallerEntity.this.m_20183_().m_123342_() != SpiritcallerEntity.this.lastY && SpiritcallerEntity.this.m_20183_().m_123343_() != SpiritcallerEntity.this.lastZ || SpiritcallerEntity.this.attackTicks < 15 || otherCheck;
        }

        public void m_8056_() {
            SpiritcallerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_ANTICHEESE.get(), 2.0f, 1.0f);
            SpiritcallerEntity.this.setSpinning(true);
            SpiritcallerEntity.this.setFaking(true);
            SpiritcallerEntity.this.attackType = SpiritcallerEntity.this.ANTICHEESE;
            SpiritcallerEntity.this.f_19794_ = true;
        }

        public void m_8041_() {
            SpiritcallerEntity.this.attackType = 0;
            SpiritcallerEntity.this.attackCooldown = 20;
            SpiritcallerEntity.this.antiCheeseCooldown = 900;
            SpiritcallerEntity.this.stuckTime = 0;
            SpiritcallerEntity.this.setFaking(false);
            SpiritcallerEntity.this.setSpinning(false);
            SpiritcallerEntity.this.f_19794_ = false;
        }
    }

    class StealSoulsGoal
    extends Goal {
        StealSoulsGoal() {
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.doesAttackMeetNormalRequirements() && (!SpiritcallerEntity.this.stolen_mobs.isEmpty() || SpiritcallerEntity.this.areStealableMobsNearby()) && SpiritcallerEntity.this.stealSoulsCooldown < 1 && SpiritcallerEntity.this.attackCooldown < 1;
        }

        public boolean m_8045_() {
            return SpiritcallerEntity.this.attackTicks <= 55;
        }

        public void m_8056_() {
            SpiritcallerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_STEALSPIRITS.get(), 2.0f, 1.0f);
            SpiritcallerEntity.this.setArmsUpward(true);
            SpiritcallerEntity.this.attackType = SpiritcallerEntity.this.SPIRIT_STEAL;
            List stealingMobs = SpiritcallerEntity.this.f_19853_.m_6443_(Mob.class, SpiritcallerEntity.this.m_20191_().m_82400_(15.0), predicate -> ((List)IllageAndSpillageConfig.spiritcaller_stealableMobs.get()).contains(predicate.m_20078_()) && !predicate.m_20147_() && predicate != SpiritcallerEntity.this);
            if (!stealingMobs.isEmpty()) {
                for (int i = 0; i < stealingMobs.size(); ++i) {
                    LivingEntity mob = (LivingEntity)stealingMobs.get(i);
                    if (!mob.m_6084_()) {
                        stealingMobs.remove(i);
                        --i;
                    }
                    SpiritcallerEntity.this.stolen_mobs.add(mob);
                }
            }
            List hands = SpiritcallerEntity.this.f_19853_.m_6443_(SpiritHandEntity.class, SpiritcallerEntity.this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == SpiritcallerEntity.this);
            for (SpiritHandEntity hand : hands) {
                hand.m_6074_();
            }
        }

        public void m_8041_() {
            SpiritcallerEntity.this.setArmsUpward(false);
            SpiritcallerEntity.this.attackType = 0;
            SpiritcallerEntity.this.attackCooldown = 20;
            SpiritcallerEntity.this.stealSoulsCooldown = 900;
            if (!SpiritcallerEntity.this.stolen_mobs.isEmpty()) {
                for (LivingEntity entity : SpiritcallerEntity.this.stolen_mobs) {
                    if (SpiritcallerEntity.this.f_19853_.f_46443_) continue;
                    MobSpiritEntity spirit = (MobSpiritEntity)((EntityType)ModEntityTypes.MobSpirit.get()).m_20615_(SpiritcallerEntity.this.f_19853_);
                    assert (spirit != null);
                    spirit.m_6034_(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_());
                    spirit.setOwner((LivingEntity)SpiritcallerEntity.this);
                    spirit.setOriginalMob(entity);
                    spirit.m_20334_(0.0, 0.5, 0.0);
                    spirit.m_6710_(SpiritcallerEntity.this.m_5448_());
                    if (SpiritcallerEntity.this.m_5647_() != null) {
                        SpiritcallerEntity.this.f_19853_.m_6188_().m_6546_(spirit.m_20149_(), SpiritcallerEntity.this.f_19853_.m_6188_().m_83489_(SpiritcallerEntity.this.m_5647_().m_5758_()));
                    }
                    spirit.setGoodOrEvil(!(entity instanceof Enemy));
                    if (entity instanceof SpiritcallerEntity) {
                        spirit.setSpiritcaller(true);
                    }
                    SpiritcallerEntity.this.f_19853_.m_7967_((Entity)spirit);
                    entity.m_20334_(0.0, 0.3, 0.0);
                    SpiritcallerEntity.this.spirits.add(spirit);
                }
            }
        }
    }

    class SoulSwarmGoal
    extends Goal {
        SoulSwarmGoal() {
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.doesAttackMeetNormalRequirements() && SpiritcallerEntity.this.checkForStolenMobs() && SpiritcallerEntity.this.f_19796_.m_188503_(12) == 0 && SpiritcallerEntity.this.stealSoulsCooldown >= 0 && SpiritcallerEntity.this.spiritSwarmCooldown < 1 && SpiritcallerEntity.this.m_21223_() < SpiritcallerEntity.this.m_21233_() / 2.0f && SpiritcallerEntity.this.attackCooldown < 1;
        }

        public boolean m_8045_() {
            return SpiritcallerEntity.this.attackTicks <= 70;
        }

        public void m_8056_() {
            SpiritcallerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_SPIRITSWARM.get(), 2.0f, 1.0f);
            SpiritcallerEntity.this.setArmsUpward(true);
            SpiritcallerEntity.this.attackType = SpiritcallerEntity.this.SOUL_SWARM;
        }

        public void m_8041_() {
            SpiritcallerEntity.this.attackType = 0;
            SpiritcallerEntity.this.attackCooldown = 20;
            SpiritcallerEntity.this.spiritSwarmCooldown = 200;
            SpiritcallerEntity.this.setArmsUpward(false);
            if (SpiritcallerEntity.this.m_5448_() != null) {
                SpiritcallerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_SOULSCREAM.get(), 3.0f, SpiritcallerEntity.this.m_6100_());
                LivingEntity entity = SpiritcallerEntity.this.m_5448_();
                double x = SpiritcallerEntity.this.m_20185_() - entity.m_20185_();
                double y = SpiritcallerEntity.this.m_20186_() - entity.m_20186_();
                double z = SpiritcallerEntity.this.m_20189_() - entity.m_20189_();
                double d = Math.sqrt(x * x + y * y + z * z);
                float power = 3.5f;
                double motionX = SpiritcallerEntity.this.m_20184_().f_82479_ - x / d * (double)power * 0.2;
                double motionY = SpiritcallerEntity.this.m_20184_().f_82480_ - y / d * (double)power * 0.2;
                double motionZ = SpiritcallerEntity.this.m_20184_().f_82481_ - z / d * (double)power * 0.2;
                SpiritcallerEntity.this.setTargetPosition(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                SpiritcallerEntity.this.setCharge(motionX, motionY, motionZ);
            } else {
                SpiritcallerEntity.this.setFaking(false);
            }
            if (SpiritcallerEntity.this.getSoulPower() > 0) {
                SpiritcallerEntity.this.setSoulPower(SpiritcallerEntity.this.getSoulPower() - 1);
            }
        }
    }

    class ImpRiseGoal
    extends Goal {
        ImpRiseGoal() {
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.doesAttackMeetNormalRequirements() && SpiritcallerEntity.this.checkForStolenMobs() && SpiritcallerEntity.this.f_19796_.m_188503_(8) == 0 && SpiritcallerEntity.this.stealSoulsCooldown >= 0 && SpiritcallerEntity.this.impRiseCooldown < 1 && SpiritcallerEntity.this.isTargetOnGround() && SpiritcallerEntity.this.attackCooldown < 1;
        }

        public boolean m_8045_() {
            return SpiritcallerEntity.this.attackTicks <= 150;
        }

        public void m_8056_() {
            SpiritcallerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_IMPRISE.get(), 2.0f, 1.0f);
            SpiritcallerEntity.this.setArmsUpward(true);
            SpiritcallerEntity.this.attackType = SpiritcallerEntity.this.IMP_RISE;
        }

        public void m_8041_() {
            SpiritcallerEntity.this.attackType = 0;
            SpiritcallerEntity.this.attackCooldown = 20;
            SpiritcallerEntity.this.impRiseCooldown = 100;
            SpiritcallerEntity.this.setArmsUpward(false);
            SpiritcallerEntity.this.setClap(false);
            if (SpiritcallerEntity.this.getSoulPower() > 0) {
                SpiritcallerEntity.this.setSoulPower(SpiritcallerEntity.this.getSoulPower() - 1);
            }
        }
    }

    class SpiritHandsGoal
    extends Goal {
        SpiritHandsGoal() {
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.doesAttackMeetNormalRequirements() && SpiritcallerEntity.this.checkForStolenMobs() && SpiritcallerEntity.this.f_19796_.m_188503_(8) == 0 && SpiritcallerEntity.this.stealSoulsCooldown >= 0 && SpiritcallerEntity.this.spiritHandsCooldown < 1 && SpiritcallerEntity.this.attackCooldown < 1;
        }

        public boolean m_8045_() {
            return SpiritcallerEntity.this.attackTicks <= 50;
        }

        public void m_8056_() {
            SpiritcallerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_SPIRITHANDS.get(), 2.0f, 1.0f);
            SpiritcallerEntity.this.setSpinning(true);
            SpiritcallerEntity.this.attackType = SpiritcallerEntity.this.SPIRIT_HANDS;
        }

        public void m_8041_() {
            SpiritcallerEntity.this.attackType = 0;
            SpiritcallerEntity.this.attackCooldown = 20;
            SpiritcallerEntity.this.spiritHandsCooldown = 900;
            SpiritcallerEntity.this.setClap(false);
            if (SpiritcallerEntity.this.getSoulPower() > 0) {
                SpiritcallerEntity.this.setSoulPower(SpiritcallerEntity.this.getSoulPower() - 1);
            }
        }
    }

    class SoulLaserGoal
    extends Goal {
        public SoulLaserGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.doesAttackMeetNormalRequirements() && SpiritcallerEntity.this.checkForStolenMobs() && SpiritcallerEntity.this.f_19796_.m_188503_(8) == 0 && SpiritcallerEntity.this.stealSoulsCooldown >= 0 && SpiritcallerEntity.this.soulLaserCooldown < 1 && SpiritcallerEntity.this.attackCooldown < 1;
        }

        public boolean m_8045_() {
            return SpiritcallerEntity.this.attackTicks <= 140;
        }

        public void m_8056_() {
            SpiritcallerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_CHARGELASER.get(), 2.0f, 1.0f);
            SpiritcallerEntity.this.setChargingLaser(true);
            SpiritcallerEntity.this.attackType = SpiritcallerEntity.this.SOUL_LASER;
        }

        public void m_8041_() {
            SpiritcallerEntity.this.attackType = 0;
            SpiritcallerEntity.this.attackCooldown = 20;
            SpiritcallerEntity.this.soulLaserCooldown = 100;
            SpiritcallerEntity.this.setLaserPosition(0.0, 0.0, 0.0);
            SpiritcallerEntity.this.setShootingLaser(false);
            if (SpiritcallerEntity.this.getSoulPower() > 0) {
                SpiritcallerEntity.this.setSoulPower(SpiritcallerEntity.this.getSoulPower() - 1);
            }
        }
    }

    class AlwaysWatchTargetGoal
    extends Goal {
        public AlwaysWatchTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            return SpiritcallerEntity.this.m_5448_() != null;
        }

        public void m_8037_() {
            SpiritcallerEntity.this.m_21573_().m_26573_();
            if (SpiritcallerEntity.this.m_5448_() != null) {
                SpiritcallerEntity.this.m_21563_().m_24960_((Entity)SpiritcallerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            SpiritcallerEntity.this.f_21344_.m_26573_();
        }
    }
}

