/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import com.yellowbrossproductions.illageandspillage.util.ItemRegisterer;
import java.util.List;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class TrickOrTreatEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> TREAT = SynchedEntityData.m_135353_(TrickOrTreatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> BOUNCE = SynchedEntityData.m_135353_(TrickOrTreatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> GOOPY = SynchedEntityData.m_135353_(TrickOrTreatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private LivingEntity owner;
    public int circleTime;
    public int bounceTime;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;

    public TrickOrTreatEntity(EntityType<? extends PathfinderMob> p_21683_, Level p_21684_) {
        super(p_21683_, p_21684_);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 50.0);
    }

    public float getStepHeight() {
        return 2.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TREAT, (Object)1);
        this.f_19804_.m_135372_(BOUNCE, (Object)false);
        this.f_19804_.m_135372_(GOOPY, (Object)false);
    }

    public boolean getBounce() {
        return (Boolean)this.f_19804_.m_135370_(BOUNCE);
    }

    public void setBounce() {
        this.f_19804_.m_135381_(BOUNCE, (Object)true);
    }

    public boolean getGoopy() {
        return (Boolean)this.f_19804_.m_135370_(GOOPY);
    }

    public void setGoopy() {
        this.f_19804_.m_135381_(GOOPY, (Object)true);
    }

    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128405_("Treat", this.getTreat());
    }

    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        this.setTreat(p_21450_.m_128451_("Treat"));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 15 == 0) {
            ++this.circleTime;
        }
        if (this.getOwner() != null) {
            if ((double)this.m_20270_((Entity)this.getOwner()) > 30.0) {
                this.m_21573_().m_5624_((Entity)this.getOwner(), 2.0);
            } else {
                this.circleOwner((Entity)this.getOwner(), 8.0f, 1.0f, true, this.circleTime, Mth.m_14089_((float)((float)this.f_19797_ / 15.0f)), 1.0f);
            }
            this.m_21563_().m_24960_((Entity)this.getOwner(), 100.0f, 100.0f);
            int timeLimit = 300 + this.bounceTime * 20;
            if (this.f_19797_ >= timeLimit) {
                if (this.f_19797_ == timeLimit) {
                    if (!this.f_19853_.f_46443_) {
                        this.setBounce();
                    }
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_TRICKORTREAT_BOUNCE.get(), 2.0f, 1.9f);
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.6, 0.0));
                    this.makeTreatParticles();
                }
                if (this.f_19797_ >= timeLimit + 10) {
                    LivingEntity entity = this.getOwner();
                    double x = this.m_20185_() - entity.m_20185_();
                    double y = this.m_20186_() - (entity.m_20186_() + 2.2);
                    double z = this.m_20189_() - entity.m_20189_();
                    double d = Math.sqrt(x * x + y * y + z * z);
                    float power = 5.0f;
                    double motionX = -(x / d * (double)power * 0.2);
                    double motionY = -(y / d * (double)power * 0.2);
                    double motionZ = -(z / d * (double)power * 0.2);
                    this.setAcceleration(motionX, motionY, motionZ);
                    this.f_19794_ = true;
                    this.m_20334_(this.accelerationX, this.accelerationY, this.accelerationZ);
                    this.makeTreatParticles();
                    if (this.m_20280_((Entity)entity) < 6.0) {
                        entity.m_5634_(5.0f);
                        this.makeHealParticles((Entity)entity);
                        this.m_6074_();
                    }
                }
            }
        }
        this.m_146922_(this.m_6080_());
        this.f_20883_ = this.m_146908_();
    }

    protected boolean m_8028_() {
        return this.getOwner() instanceof Monster;
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return 1.06f;
    }

    public void setAcceleration(double x, double y, double z) {
        this.accelerationX = x;
        this.accelerationY = y;
        this.accelerationZ = z;
    }

    public void makeTreatParticles() {
        if (!this.f_19853_.f_46443_) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.f_19853_).m_6907_()) {
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 10; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    ParticleOptions $$1 = this.getParticle();
                    packet.queueParticle($$1, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
            }
        }
    }

    public void makeHealParticles(Entity caught) {
        if (!this.f_19853_.f_46443_) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.f_19853_).m_6907_()) {
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 6; ++i) {
                    double d0 = -0.5 + this.f_19796_.m_188583_();
                    double d1 = -0.5 + this.f_19796_.m_188583_();
                    double d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123750_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
            }
        }
    }

    public void resetTargeters() {
        List list = this.f_19853_.m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
        if (this.getOwner() != null) {
            for (Mob attacker : list) {
                if (attacker.m_21188_() == this && this.getOwner() != null) {
                    attacker.m_6703_(this.getOwner());
                }
                if (attacker.m_5448_() == this && this.getOwner() != null) {
                    attacker.m_6710_(this.getOwner());
                }
                LivingEntity owner = this.getOwner();
                if (!(attacker instanceof Warden)) {
                    try {
                        if (attacker.m_6274_() == null || !attacker.m_6274_().m_21874_(MemoryModuleType.f_26372_) || !attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).isPresent() || attacker.m_6274_().m_21952_(MemoryModuleType.f_26372_).get() != this) continue;
                        attacker.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)owner.m_20148_(), 600L);
                        attacker.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)owner, 600L);
                    }
                    catch (NullPointerException nullPointerException) {}
                    continue;
                }
                Warden warden = (Warden)attacker;
                if (warden.m_5448_() != this) continue;
                warden.m_219387_((Entity)owner, AngerLevel.ANGRY.m_219226_() + 100, false);
                warden.m_219459_(owner);
            }
        }
    }

    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public int getTreat() {
        return (Integer)this.f_19804_.m_135370_(TREAT);
    }

    public void setTreat(int t) {
        this.f_19804_.m_135381_(TREAT, (Object)t);
    }

    protected void m_6138_() {
    }

    public void m_6667_(DamageSource p_21014_) {
        super.m_6667_(p_21014_);
        this.f_20919_ = 19;
        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FREAKAGER_TRICKORTREAT_DESTROY.get(), 1.5f, 1.0f);
        this.makeTreatDestroyedParticles();
        this.resetTargeters();
    }

    private void circleOwner(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        int directionInt = direction ? 1 : 1;
        double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        Vec3 movePos = target.m_20182_().m_82520_((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
        this.m_21573_().m_26519_(movePos.m_7096_(), movePos.m_7098_(), movePos.m_7094_(), (double)(speed * moveSpeedMultiplier));
    }

    private ParticleOptions getParticle() {
        ItemStack a = ((Item)ItemRegisterer.TREAT1.get()).m_7968_();
        ItemStack b = ((Item)ItemRegisterer.TREAT2.get()).m_7968_();
        ItemStack c = ((Item)ItemRegisterer.TREAT3.get()).m_7968_();
        ItemStack d = ((Item)ItemRegisterer.TREAT4.get()).m_7968_();
        ItemStack e = ((Item)ItemRegisterer.TREAT5.get()).m_7968_();
        return switch (this.getTreat()) {
            default -> new ItemParticleOption(ParticleTypes.f_123752_, a);
            case 2 -> new ItemParticleOption(ParticleTypes.f_123752_, b);
            case 3 -> new ItemParticleOption(ParticleTypes.f_123752_, c);
            case 4 -> new ItemParticleOption(ParticleTypes.f_123752_, d);
            case 5 -> new ItemParticleOption(ParticleTypes.f_123752_, e);
        };
    }

    public void makeTreatDestroyedParticles() {
        if (!this.f_19853_.f_46443_) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.f_19853_).m_6907_()) {
                double d2;
                double d1;
                double d0;
                int i;
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (i = 0; i < 15; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123813_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 150; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    ParticleOptions $$1 = this.getParticle();
                    packet.queueParticle($$1, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
            }
        }
    }
}

