/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.mixin;

import com.hrznstudio.emojiful.ClientEmojiHandler;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.platform.Services;
import net.minecraft.client.gui.screens.ChatScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ChatScreen.class})
public class ShortReplacementMixin {
    @ModifyVariable(method={"handleChatInput"}, at=@At(value="HEAD"), argsOnly=true)
    private String getValueForHandleChatInput(String original) {
        return this.replaceShortEmojis(original);
    }

    @ModifyVariable(method={"updateChatPreview"}, at=@At(value="HEAD"), argsOnly=true)
    private String getValueForUpdateChatPreview(String original) {
        return this.replaceShortEmojis(original);
    }

    private String replaceShortEmojis(String message) {
        if (Services.CONFIG.renderEmoji() && Services.CONFIG.shortEmojiReplacement()) {
            for (Emoji emoji : ClientEmojiHandler.EMOJI_WITH_TEXTS) {
                if (emoji.texts.size() <= 0) continue;
                message = message.replaceAll(emoji.getTextRegex(), emoji.getShorterString());
            }
        }
        return message;
    }
}

