/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SpongeSchematicWriter
implements ClipboardWriter {
    private static final int CURRENT_VERSION = 2;
    private static final int MAX_SIZE = 65535;
    private final NBTOutputStream outputStream;

    public SpongeSchematicWriter(NBTOutputStream outputStream) {
        Preconditions.checkNotNull((Object)outputStream);
        this.outputStream = outputStream;
    }

    @Override
    public void write(Clipboard clipboard) throws IOException {
        this.outputStream.writeNamedTag("Schematic", new CompoundTag(this.write2(clipboard)));
    }

    private Map<String, Tag> write2(Clipboard clipboard) {
        Region region = clipboard.getRegion();
        BlockVector3 origin = clipboard.getOrigin();
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 offset = min.subtract(origin);
        int width = region.getWidth();
        int height = region.getHeight();
        int length = region.getLength();
        if (width > 65535) {
            throw new IllegalArgumentException("Width of region too large for a .schematic");
        }
        if (height > 65535) {
            throw new IllegalArgumentException("Height of region too large for a .schematic");
        }
        if (length > 65535) {
            throw new IllegalArgumentException("Length of region too large for a .schematic");
        }
        HashMap<String, Tag> schematic = new HashMap<String, Tag>();
        schematic.put("Version", new IntTag(2));
        schematic.put("DataVersion", new IntTag(WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getDataVersion()));
        HashMap<String, Tag> metadata = new HashMap<String, Tag>();
        metadata.put("WEOffsetX", new IntTag(offset.getBlockX()));
        metadata.put("WEOffsetY", new IntTag(offset.getBlockY()));
        metadata.put("WEOffsetZ", new IntTag(offset.getBlockZ()));
        schematic.put("Metadata", new CompoundTag(metadata));
        schematic.put("Width", new ShortTag((short)width));
        schematic.put("Height", new ShortTag((short)height));
        schematic.put("Length", new ShortTag((short)length));
        schematic.put("Offset", new IntArrayTag(new int[]{min.getBlockX(), min.getBlockY(), min.getBlockZ()}));
        int paletteMax = 0;
        HashMap<String, Integer> palette = new HashMap<String, Integer>();
        ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(width * height * length);
        for (int y = 0; y < height; ++y) {
            int y0 = min.getBlockY() + y;
            for (int z = 0; z < length; ++z) {
                int z0 = min.getBlockZ() + z;
                for (int x = 0; x < width; ++x) {
                    int blockId;
                    String blockKey;
                    int x0 = min.getBlockX() + x;
                    BlockVector3 point = BlockVector3.at(x0, y0, z0);
                    BaseBlock block = clipboard.getFullBlock(point);
                    if (block.getNbtData() != null) {
                        HashMap<String, Tag> values = new HashMap<String, Tag>((Map<String, Tag>)block.getNbtData().getValue());
                        values.remove("id");
                        values.remove("x");
                        values.remove("y");
                        values.remove("z");
                        values.put("Id", new StringTag(block.getNbtId()));
                        values.put("Pos", new IntArrayTag(new int[]{x, y, z}));
                        tileEntities.add(new CompoundTag(values));
                    }
                    if (palette.containsKey(blockKey = block.toImmutableState().getAsString())) {
                        blockId = (Integer)palette.get(blockKey);
                    } else {
                        blockId = paletteMax++;
                        palette.put(blockKey, blockId);
                    }
                    while ((blockId & 0xFFFFFF80) != 0) {
                        buffer.write(blockId & 0x7F | 0x80);
                        blockId >>>= 7;
                    }
                    buffer.write(blockId);
                }
            }
        }
        schematic.put("PaletteMax", new IntTag(paletteMax));
        HashMap<String, Tag> paletteTag = new HashMap<String, Tag>();
        palette.forEach((key, value) -> paletteTag.put((String)key, new IntTag((int)value)));
        schematic.put("Palette", new CompoundTag(paletteTag));
        schematic.put("BlockData", new ByteArrayTag(buffer.toByteArray()));
        schematic.put("BlockEntities", new ListTag(CompoundTag.class, tileEntities));
        if (clipboard.hasBiomes()) {
            this.writeBiomes(clipboard, schematic);
        }
        if (!clipboard.getEntities().isEmpty()) {
            this.writeEntities(clipboard, schematic);
        }
        return schematic;
    }

    private void writeBiomes(Clipboard clipboard, Map<String, Tag> schematic) {
        BlockVector3 min = clipboard.getMinimumPoint();
        int width = clipboard.getRegion().getWidth();
        int length = clipboard.getRegion().getLength();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(width * length);
        int paletteMax = 0;
        HashMap<String, Integer> palette = new HashMap<String, Integer>();
        for (int z = 0; z < length; ++z) {
            int z0 = min.getBlockZ() + z;
            for (int x = 0; x < width; ++x) {
                int biomeId;
                int x0 = min.getBlockX() + x;
                BlockVector3 pt = BlockVector3.at(x0, min.getBlockY(), z0);
                BiomeType biome = clipboard.getBiome(pt);
                String biomeKey = biome.getId();
                if (palette.containsKey(biomeKey)) {
                    biomeId = (Integer)palette.get(biomeKey);
                } else {
                    biomeId = paletteMax++;
                    palette.put(biomeKey, biomeId);
                }
                while ((biomeId & 0xFFFFFF80) != 0) {
                    buffer.write(biomeId & 0x7F | 0x80);
                    biomeId >>>= 7;
                }
                buffer.write(biomeId);
            }
        }
        schematic.put("BiomePaletteMax", new IntTag(paletteMax));
        HashMap<String, Tag> paletteTag = new HashMap<String, Tag>();
        palette.forEach((key, value) -> paletteTag.put((String)key, new IntTag((int)value)));
        schematic.put("BiomePalette", new CompoundTag(paletteTag));
        schematic.put("BiomeData", new ByteArrayTag(buffer.toByteArray()));
    }

    private void writeEntities(Clipboard clipboard, Map<String, Tag> schematic) {
        List entities = clipboard.getEntities().stream().map(e -> {
            BaseEntity state = e.getState();
            if (state == null) {
                return null;
            }
            HashMap values = Maps.newHashMap();
            CompoundTag rawData = state.getNbtData();
            if (rawData != null) {
                values.putAll(rawData.getValue());
            }
            values.remove("id");
            values.put("Id", new StringTag(state.getType().getId()));
            Location location = e.getLocation();
            values.put("Pos", this.writeVector(location.toVector()));
            values.put("Rotation", this.writeRotation(location));
            return new CompoundTag(values);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (entities.isEmpty()) {
            return;
        }
        schematic.put("Entities", new ListTag(CompoundTag.class, entities));
    }

    private Tag writeVector(Vector3 vector) {
        ArrayList<DoubleTag> list = new ArrayList<DoubleTag>();
        list.add(new DoubleTag(vector.getX()));
        list.add(new DoubleTag(vector.getY()));
        list.add(new DoubleTag(vector.getZ()));
        return new ListTag(DoubleTag.class, list);
    }

    private Tag writeRotation(Location location) {
        ArrayList<FloatTag> list = new ArrayList<FloatTag>();
        list.add(new FloatTag(location.getYaw()));
        list.add(new FloatTag(location.getPitch()));
        return new ListTag(FloatTag.class, list);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

