/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.forge;

import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.compat.waystones.WaystonesCompat;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.Protection;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="ftbchunks")
public class FTBChunksForge {
    public FTBChunksForge() {
        EventBuses.registerModEventBus((String)"ftbchunks", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.addListener(this::entityInteractSpecific);
        MinecraftForge.EVENT_BUS.addListener(this::attackNonLivingEntity);
        FTBChunks.instance = new FTBChunks();
        ForgeChunkManager.setForcedChunkLoadingCallback((String)"ftbchunks", this::validateLoadedChunks);
        if (Platform.isModLoaded((String)"waystones")) {
            WaystonesCompat.init();
        }
    }

    private void attackNonLivingEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (!(event.getTarget() instanceof LivingEntity) && FTBChunksAPI.getManager().protect((Entity)sp, sp.m_7655_(), sp.m_20183_(), Protection.ATTACK_NONLIVING_ENTITY, event.getTarget())) {
                event.setCanceled(true);
            }
        }
    }

    private void entityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!event.getEntity().f_19853_.f_46443_ && FTBChunksAPI.getManager().protect((Entity)event.getEntity(), event.getHand(), event.getEntity().m_20183_(), Protection.INTERACT_ENTITY, event.getTarget())) {
            event.setCancellationResult(InteractionResult.FAIL);
            event.setCanceled(true);
        }
    }

    private void validateLoadedChunks(ServerLevel level, ForgeChunkManager.TicketHelper ticketHelper) {
        ticketHelper.getEntityTickets().forEach((id, chunks) -> {
            HashSet toRemove = new HashSet();
            ((LongSet)chunks.getSecond()).forEach(l -> {
                ClaimedChunk cc = FTBChunksAPI.getManager().getChunk(new ChunkDimPos(level.m_46472_(), new ChunkPos(l)));
                if (cc == null || !cc.teamData.getTeamId().equals(id) || !cc.isActuallyForceLoaded()) {
                    toRemove.add(l);
                }
            });
            toRemove.forEach(l -> ticketHelper.removeTicket(id, l.longValue(), true));
            if (!toRemove.isEmpty()) {
                FTBChunks.LOGGER.info("cleaned up {} stale Forge chunkloading tickets for team ID {} in dimension {}", (Object)toRemove.size(), id, (Object)level.m_46472_().m_135782_());
            }
        });
    }
}

