/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.alchemy.Potion;
import org.jetbrains.annotations.Nullable;
import twilightforest.TwilightForestMod;

public class DrinkFromFlaskTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = TwilightForestMod.prefix("drink_from_flask");

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected Instance createInstance(JsonObject json, EntityPredicate.Composite player, DeserializationContext ctx) {
        Potion potion = null;
        if (json.has("potion")) {
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"potion"));
            potion = (Potion)Registry.f_122828_.m_6612_(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Unknown potion '" + resourcelocation + "'"));
        }
        if (json.has("doses") && GsonHelper.m_13927_((JsonObject)json, (String)"doses") > 4) {
            throw new JsonSyntaxException("DrinkFromFlaskTrigger: can't have more than 4 doses.");
        }
        MinMaxBounds.Ints doses = MinMaxBounds.Ints.m_55373_((JsonElement)json.get("doses"));
        return new Instance(player, doses, potion);
    }

    public void trigger(ServerPlayer player, int doses, Potion potion) {
        this.m_66234_(player, instance -> instance.matches(doses, potion));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final MinMaxBounds.Ints doses;
        @Nullable
        private final Potion potion;

        public Instance(EntityPredicate.Composite player, MinMaxBounds.Ints doses, @Nullable Potion potion) {
            super(ID, player);
            this.doses = doses;
            this.potion = potion;
        }

        public static Instance drankPotion(int doses, Potion potion) {
            return new Instance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.m_55371_((int)doses), potion);
        }

        public boolean matches(int doses, Potion potion) {
            return this.doses.m_55390_(doses) && this.potion != null && this.potion == potion;
        }

        public JsonObject m_7683_(SerializationContext ctx) {
            JsonObject object = super.m_7683_(ctx);
            object.add("doses", this.doses.m_55328_());
            if (this.potion != null) {
                object.addProperty("potion", Registry.f_122828_.m_7981_((Object)this.potion).toString());
            }
            return object;
        }
    }
}

