/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import twilightforest.command.TFCommand;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.components.structures.start.TFStructureStart;
import twilightforest.world.registration.TFGenerationSettings;

public class ConquerCommand {
    private static final SimpleCommandExceptionType NOT_IN_STRUCTURE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.tffeature.structure.required"));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        LiteralArgumentBuilder conquer = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"conquer").requires(cs -> cs.m_6761_(2))).executes(ctx -> ConquerCommand.changeStructureActivity((CommandSourceStack)ctx.getSource(), true));
        LiteralArgumentBuilder reactivate = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reactivate").requires(cs -> cs.m_6761_(2))).executes(ctx -> ConquerCommand.changeStructureActivity((CommandSourceStack)ctx.getSource(), false));
        return (LiteralArgumentBuilder)conquer.then((ArgumentBuilder)reactivate);
    }

    private static int changeStructureActivity(CommandSourceStack source, boolean flag) throws CommandSyntaxException {
        if (!TFGenerationSettings.usesTwilightChunkGenerator(source.m_81372_())) {
            throw TFCommand.NOT_IN_TF.create();
        }
        ChunkGeneratorTwilight chunkGenerator = WorldUtil.getChunkGenerator((LevelAccessor)source.m_81372_());
        BlockPos pos = new BlockPos(source.m_81371_());
        if (chunkGenerator != null) {
            Optional<TFStructureStart> struct = TFGenerationSettings.locateTFStructureInRange((WorldGenLevel)source.m_81372_(), pos, 0).map(s -> (TFStructureStart)((Object)s));
            if (struct.isEmpty()) {
                throw NOT_IN_STRUCTURE.create();
            }
            struct.ifPresent(structure -> {
                source.m_81354_((Component)Component.m_237110_((String)"commands.tffeature.structure.conquer.update", (Object[])new Object[]{structure.isConquered(), flag}), true);
                structure.setConquered(flag);
            });
            return 1;
        }
        throw NOT_IN_STRUCTURE.create();
    }
}

