/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness.client;

import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class SoundRegistry {
    private static HashMap<String, SoundEvent> lookupStringToEvent = new HashMap();
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"zombieawareness");

    public static void init() {
        SoundRegistry.register("alert");
        SoundRegistry.register("target");
        SoundRegistry.register("investigate");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        SOUND_EVENTS.register(modEventBus);
    }

    public static void register(String name) {
        SoundEvent event = new SoundEvent(new ResourceLocation("zombieawareness", name));
        lookupStringToEvent.put(name, event);
        SOUND_EVENTS.register(name, () -> event);
    }

    public static SoundEvent get(String soundPath) {
        return lookupStringToEvent.get(soundPath);
    }
}

