/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.mining_helmet.client.model;

import com.legacy.mining_helmet.MiningHelmetMod;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class LightBeamModel<T extends LivingEntity>
extends HumanoidModel<T> {
    private static final ResourceLocation TEXTURE_LIGHT = MiningHelmetMod.locate("textures/models/armor/mining_helmet_light.png");
    public ModelPart lightBeam;

    public LightBeamModel(ModelPart model) {
        super(model);
        this.lightBeam = model.m_171324_("light_beam");
    }

    public static LayerDefinition createBeamLayer(CubeDeformation size, boolean coverFace) {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)size, (float)0.0f);
        PartDefinition root = mesh.m_171576_();
        CubeDeformation scale = CubeDeformation.f_171458_;
        float offsetAmount = !coverFace ? 2.0f : 1.0f;
        root.m_171599_("light_beam", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -9.0f - offsetAmount, -13.0f, 4.0f, 4.0f, 8.0f, scale), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)24, (int)12);
    }

    protected Iterable<ModelPart> m_5607_() {
        float offset = this.f_102808_.f_104201_;
        this.lightBeam.m_104315_(this.f_102808_);
        this.lightBeam.f_104201_ = offset;
        return List.of(this.lightBeam);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of();
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        VertexConsumer ivertexbuilder = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE_LIGHT));
        this.m_5607_().forEach(modelRenderer -> {
            float intensef = 1.0f + (float)(packedLightIn / 8) * 0.01f;
            System.out.println(intensef);
            modelRenderer.m_104306_(matrixStackIn, ivertexbuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha * intensef);
        });
    }
}

