/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.PermissionValue;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankCondition;
import dev.ftb.mods.ftbranks.impl.BooleanPermissionValue;
import dev.ftb.mods.ftbranks.impl.FTBRanksAPIImpl;
import dev.ftb.mods.ftbranks.impl.NumberPermissionValue;
import dev.ftb.mods.ftbranks.impl.StringPermissionValue;
import dev.ftb.mods.ftbranks.impl.condition.DefaultCondition;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.apache.commons.lang3.math.NumberUtils;

public class FTBRanksCommands {
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_RANK = new DynamicCommandExceptionType(object -> Component.m_237113_((String)("Unknown rank: " + object.toString())));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ftbranks").requires(source -> source.m_81377_().m_129792_() || source.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(context -> FTBRanksCommands.reloadRanks((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"refresh_readme").executes(context -> FTBRanksCommands.refreshReadme((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"list_all_ranks").executes(context -> FTBRanksCommands.listAllRanks((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FTBRanksCommands.createRank((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.deleteRank((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank")))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.addRank((CommandSourceStack)context.getSource(), GameProfileArgument.m_94590_((CommandContext)context, (String)"players"), StringArgumentType.getString((CommandContext)context, (String)"rank"))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"players", (ArgumentType)GameProfileArgument.m_94584_()).then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.removeRank((CommandSourceStack)context.getSource(), GameProfileArgument.m_94590_((CommandContext)context, (String)"players"), StringArgumentType.getString((CommandContext)context, (String)"rank"))))))).then(Commands.m_82127_((String)"list_ranks_of").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> FTBRanksCommands.listRanksOf((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"list_players_with").then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.listPlayersWith((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"node").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).then(Commands.m_82129_((String)"node", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FTBRanksCommands.setNode((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"), StringArgumentType.getString((CommandContext)context, (String)"node"), StringArgumentType.getString((CommandContext)context, (String)"value")))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).then(Commands.m_82129_((String)"node", (ArgumentType)StringArgumentType.word()).executes(context -> FTBRanksCommands.setNode((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"), StringArgumentType.getString((CommandContext)context, (String)"node"), null))))))).then(Commands.m_82127_((String)"condition").then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FTBRanksCommands.setCondition((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"), StringArgumentType.getString((CommandContext)context, (String)"value"))))))).then(Commands.m_82127_((String)"show_rank").then(Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.showRank((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"))))));
    }

    private static CompletableFuture<Suggestions> suggestRanks(SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(FTBRanksAPI.INSTANCE.getManager().getAllRanks().stream().map(Rank::getId), (SuggestionsBuilder)builder);
    }

    private static String normalizeRankName(String name) {
        return name.toLowerCase().replace("+", "_plus").replaceAll("[^a-z0-9_]", "_").replaceAll("_{2,}", "_");
    }

    private static int reloadRanks(CommandSourceStack source) {
        try {
            FTBRanksAPIImpl.manager.reload();
            source.m_81354_((Component)Component.m_237113_((String)"Ranks reloaded from disk!"), true);
            for (ServerPlayer p : source.m_81377_().m_6846_().m_11314_()) {
                source.m_81377_().m_6846_().m_11289_(p);
            }
            return 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            source.m_81352_((Component)Component.m_237113_((String)ex.getLocalizedMessage()));
            return 0;
        }
    }

    private static int refreshReadme(CommandSourceStack source) {
        try {
            FTBRanksAPIImpl.manager.refreshReadme();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        source.m_81354_((Component)Component.m_237113_((String)"README file refreshed!"), false);
        return 1;
    }

    private static int listAllRanks(CommandSourceStack source) {
        source.m_81354_((Component)Component.m_237113_((String)"Ranks:"), false);
        for (Rank rank : FTBRanksAPIImpl.manager.getAllRanks()) {
            source.m_81354_((Component)Component.m_237113_((String)("- " + rank.getName())).m_130940_(rank.getCondition().isDefaultCondition() ? ChatFormatting.AQUA : ChatFormatting.YELLOW), false);
        }
        return 1;
    }

    private static int createRank(CommandSourceStack source, String name) {
        String id = FTBRanksCommands.normalizeRankName(name);
        if (FTBRanksAPIImpl.manager.getRank(id).isPresent()) {
            source.m_81352_((Component)Component.m_237113_((String)("Rank '" + name + "' is already taken!")));
            return 0;
        }
        FTBRanksAPIImpl.manager.createRank(id, name);
        source.m_81354_((Component)Component.m_237113_((String)("Rank '" + id + "' created!")), false);
        return 1;
    }

    private static int deleteRank(CommandSourceStack source, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        FTBRanksAPI.INSTANCE.getManager().deleteRank(rank.getId());
        source.m_81354_((Component)Component.m_237113_((String)("Rank '" + rank.getName() + "' deleted!")), false);
        return 1;
    }

    private static int addRank(CommandSourceStack source, Collection<GameProfile> players, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        for (GameProfile profile : players) {
            if (!rank.add(profile)) continue;
            source.m_81354_((Component)Component.m_237113_((String)String.format("Player %s added to rank '%s'!", profile.getName(), rank.getName())), false);
        }
        return 1;
    }

    private static int removeRank(CommandSourceStack source, Collection<GameProfile> players, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        for (GameProfile profile : players) {
            if (!rank.remove(profile)) continue;
            source.m_81354_((Component)Component.m_237113_((String)String.format("Player %s removed from rank '%s'!", profile.getName(), rank.getName())), false);
        }
        return 1;
    }

    private static int listRanksOf(CommandSourceStack source, ServerPlayer player) {
        source.m_81354_((Component)Component.m_237113_((String)String.format("Ranks added to player '%s':", player.m_36316_().getName())), false);
        for (Rank rank : FTBRanksAPIImpl.manager.getAllRanks()) {
            if (!rank.isActive(player)) continue;
            source.m_81354_((Component)Component.m_237113_((String)("- " + rank.getName())).m_130940_(rank.getCondition().isDefaultCondition() ? ChatFormatting.AQUA : ChatFormatting.YELLOW), false);
        }
        return 1;
    }

    private static int listPlayersWith(CommandSourceStack source, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        source.m_81354_((Component)Component.m_237113_((String)String.format("Players with rank '%s':", rank.getName())), false);
        for (ServerPlayer player : source.m_81377_().m_6846_().m_11314_()) {
            if (!rank.isActive(player)) continue;
            source.m_81354_((Component)Component.m_237113_((String)"- ").m_130940_(ChatFormatting.YELLOW).m_7220_(player.m_5446_()), false);
        }
        return 1;
    }

    private static int setNode(CommandSourceStack source, String rankName, String node, String value) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        try {
            rank.setPermission(node, FTBRanksCommands.strToPermissionValue(value));
            if (value != null) {
                source.m_81354_((Component)Component.m_237113_((String)String.format("Permission node '%s'='%s' added to rank '%s'", node, rank.getPermission(node), rank)), false);
            } else {
                source.m_81354_((Component)Component.m_237113_((String)String.format("Permission node '%s' removed from rank '%s'", node, rank)), false);
            }
        }
        catch (IllegalArgumentException e) {
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)e.getMessage())).create();
        }
        return 1;
    }

    private static int setCondition(CommandSourceStack source, String rankName, String value) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        try {
            RankCondition condition = value.equals("default") || value.equals("\"\"") ? new DefaultCondition(rank) : (value.startsWith("{") || value.contains(" ") ? FTBRanksAPI.INSTANCE.getManager().createCondition(rank, (Tag)SNBT.readLines(Collections.singletonList(value))) : FTBRanksAPI.INSTANCE.getManager().createCondition(rank, (Tag)StringTag.m_129297_((String)value)));
            rank.setCondition(condition);
            source.m_81354_((Component)Component.m_237113_((String)String.format("Condition '%s' added to rank '%s'", value, rank)), false);
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)e.getMessage())).create();
        }
        return 1;
    }

    private static int showRank(CommandSourceStack source, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        source.m_81354_((Component)Component.m_237113_((String)"=".repeat(50)).m_130940_(ChatFormatting.GREEN), false);
        source.m_81354_((Component)Component.m_237113_((String)String.format("Rank ID: %s, Rank Name: %s, Power: %d", rank.getId(), rank.getName(), rank.getPower())).m_130940_(ChatFormatting.YELLOW), false);
        String condStr = rank.getCondition().asString();
        MutableComponent c = condStr.isEmpty() ? Component.m_237113_((String)"(none: players must be added)").m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}) : Component.m_237113_((String)condStr);
        source.m_81354_((Component)Component.m_237113_((String)"Condition: ").m_7220_((Component)c).m_130940_(ChatFormatting.YELLOW), false);
        source.m_81354_((Component)Component.m_237113_((String)"Permission nodes:").m_130940_(ChatFormatting.YELLOW), false);
        rank.getPermissions().stream().sorted().forEach(node -> source.m_81354_((Component)Component.m_237113_((String)(" - " + node + ": " + rank.getPermission((String)node))), false));
        return 0;
    }

    private static PermissionValue strToPermissionValue(String str) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return StringPermissionValue.of(str.substring(1, str.length() - 1));
        }
        if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false")) {
            return BooleanPermissionValue.of(str.equalsIgnoreCase("true"));
        }
        if (NumberUtils.isCreatable((String)str)) {
            return NumberPermissionValue.of(NumberUtils.createNumber((String)str));
        }
        return StringPermissionValue.of(str);
    }

    private static Rank getRank(String rankName) throws CommandSyntaxException {
        return FTBRanksAPI.INSTANCE.getManager().getRank(rankName).orElseThrow(() -> ERROR_UNKNOWN_RANK.create((Object)rankName));
    }
}

