/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.IContextAwareContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BackpackContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.settings.BackpackMainSettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SettingsContainerMenu;

public class BackpackSettingsContainerMenu
extends SettingsContainerMenu<IBackpackWrapper>
implements IContextAwareContainer {
    private final BackpackContext backpackContext;
    private CompoundTag lastSettingsNbt = null;

    protected BackpackSettingsContainerMenu(int windowId, Player player, BackpackContext backpackContext) {
        super((MenuType)ModItems.SETTINGS_CONTAINER_TYPE.get(), windowId, player, (IStorageWrapper)backpackContext.getBackpackWrapper(player));
        this.backpackContext = backpackContext;
    }

    public static BackpackSettingsContainerMenu fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        return new BackpackSettingsContainerMenu(windowId, playerInventory.f_35978_, BackpackContext.fromBuffer(packetBuffer, playerInventory.f_35978_.f_19853_));
    }

    public void detectSettingsChangeAndReload() {
        if (this.player.f_19853_.f_46443_) {
            ((IBackpackWrapper)this.storageWrapper).getContentsUuid().ifPresent(uuid -> {
                BackpackStorage storage = BackpackStorage.get();
                if (storage.removeUpdatedBackpackSettingsFlag((UUID)uuid)) {
                    ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().reloadFrom(storage.getOrCreateBackpackContents((UUID)uuid));
                }
            });
        }
    }

    public void m_38946_() {
        super.m_38946_();
        this.sendBackpackSettingsToClient();
    }

    private void sendBackpackSettingsToClient() {
        if (this.player.f_19853_.f_46443_) {
            return;
        }
        if (this.lastSettingsNbt == null || !this.lastSettingsNbt.equals((Object)((IBackpackWrapper)this.storageWrapper).getSettingsHandler().getNbt())) {
            this.lastSettingsNbt = ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().getNbt().m_6426_();
            ((IBackpackWrapper)this.storageWrapper).getContentsUuid().ifPresent(uuid -> {
                CompoundTag settingsContents = new CompoundTag();
                CompoundTag settingsNbt = ((IBackpackWrapper)this.storageWrapper).getSettingsHandler().getNbt();
                if (!settingsNbt.m_128456_()) {
                    settingsContents.m_128365_("settings", (Tag)settingsNbt);
                    SophisticatedBackpacks.PACKET_HANDLER.sendToClient((ServerPlayer)this.player, new BackpackContentsMessage((UUID)uuid, settingsContents));
                }
            });
        }
    }

    @Override
    public BackpackContext getBackpackContext() {
        return this.backpackContext;
    }

    static {
        SettingsContainerMenu.addFactory((String)"backpackGlobal", BackpackMainSettingsContainer::new);
    }
}

